<?php
/**
 * Список новостей за указанную дату (выбранную в календаре)
 * @var $items array
 */
?>
<h1><?= _t('pub','Новости'); ?> <span class="sub"><?= _t('pub','за [date]', array('date'=>$date)); ?></span></h1>
<div class="center-area">
    <? foreach ($items as $typeID=>$itemsList) {
        $title = '';
        switch ($typeID) {
            case Publications::TYPE_ARTICLES: continue 2;
            case Publications::TYPE_VIDEO:    continue 2;
            case Publications::TYPE_NEWS:    $title = _t('pub','ЛЕНТА НОВОСТЕЙ');   break;
            case Publications::TYPE_REPORTS: $title = _t('pub','ФОТОРЕПОРТАЖИ');    break;
            case Publications::TYPE_NAROD:   $title = _t('pub','НАРОДНЫЕ НОВОСТИ'); break;
        } ?>
        <h3 class="mt20"><?= $title ?></h3>
        <div class="news-list mb40">
            <? foreach($itemsList as $v) { ?>
            <div class="item">
                <span class="date"><?= tpl::date_format_pub( (int)$v['publicated_n'] ); ?> |</span>  <a href="<?= $v['cat_link'] ?>" class="f11"><?= $v['cat_title'] ?></a><br>
                <span class="title"><?= $v['title'] ?></span>
                <? if ($v['img'] && ! empty($v['content_short'])) { ?>
                    <a href="<?= $v['link'] ?>"><img src="<?= $v['img'] ?>" width="100" alt="<?= $v['title_alt'] ?>" class="right" /></a>
                    <p><?= $v['content_short'] ?></p>
                <? } else { ?>
                    <p><?= $v['content_short'] ?></p>
                <? } ?>
                <div class="clear"></div>
            </div>
            <? } ?>
        </div>
    <? } ?>
</div>