<?php
/**
 * Список объявлений компании
 * @var $items array
 * @var $oImages RealtyImages
 */
    if( !empty($items)):
    $oImages = $this->initImages();
    $userID = User::id();
    $priceParams = $this->getPriceParams();
?>
    <div class="realty">
        <div class="realty-list">
            <table width="100%">
                <? foreach($items as $v): ?>
                    <tr class="item<? if($v['marked']) { ?> svc-item-marked<? } elseif($v['fixed']) { ?> fixed<? } ?>">
                        <td class="image">
                            <a href="<?= $v['url'] ?>"><img alt="" src="<?= $v['img'] ?>"></a>
                        </td>
                        <td>
                            <a href="<?= Realty::url('view', $v['link']) ?>"><b><?= $v['address'] ?></b></a>
                            <div class="f12 mt5">
                                <?= $v['descshort'] ?>
                            </div>
                        </td>
                        <td class="price">
                            <div class="green mb5"><b><?= tpl::formatPrice($v['price'], $v['price_curr']) ?></b></div>
                            <? foreach($this->getPriceParams() as $ppKey=>$ppTitle) {
                                if($v['pricep'] & $ppKey){ ?><div class="mb5"><span class="grey f12"><?= $ppTitle ?></span></div><? }
                            } ?>
                            <? if($userID) { ?>
                                <div>
                                    <?
                                    if( ! $v['fav']){ ?>
                                        <a href="#" onclick="return app.fav('realty',this);" data-id="<?= $v['id'] ?>" class="intofav" title="<?= _t('', 'В избранное') ?>"></a>
                                    <? } else { ?>
                                        <a href="#" onclick="return app.fav('realty',this);" data-id="<?= $v['id'] ?>" class="infav" title="<?= _t('', 'Избранное') ?>"></a>
                                    <? } ?>
                                </div>
                            <? } ?>
                        </td>
                    </tr>
                <? endforeach; ?>
            </table>

        </div>
    </div>
    <?= $pgn; ?>

<? else: ?>
    <div class="mt35 text-center grey f12">
        <?= _t('', 'Нет объявлений') ?>
    </div>
<? endif; ?>