<?php use bff\db\Dynprops;

$prefix = (isset($aData['prefix'])?$aData['prefix']:'dynprops');
$prefix_id = 'realty_dp_';
$f = $aData['extra']['f'];

foreach($aData['dynprops'] as $d)
{
    $name = $prefix.'['.$d['data_field'].']';
    $extra = 'dyntype="'.$d['type'].'" id="'.$prefix_id.$d['id'].'"';

    if($d['type'] == Dynprops::typeCheckbox) {
        $checkboxTitle = HTML::escape($d['title']);
    }
    $extraClass = '';

    if(isset($f[ $d['data_field'] ])) {
        $d['value'] = $f[ $d['data_field'] ];
    }

    switch ($d['type'])
    {
         case Dynprops::typeRadioGroup:
        {
            $value = (isset($d['value']) && $d['value'] ? $d['value'] : array());
            ?><div class="b-param">
                <p class="param-name"><?= $d['title']; ?></p>
                <?php
                    echo $this->formCols($d['multi'], $value, create_function('$k,$dm,$value', '
                        return \'<li><label><input type="checkbox" name="'.$name.'[\'.$k.\']" class="'.$extraClass.'" '.$extra.' title="\'.$dm[\'name\'].\'" value="\'.$dm[\'value\'].\'" \'.(in_array($dm[\'value\'], $value)?\' checked="checked"\':\'\').\' /> \'.$dm[\'name\'].\'</label></li>\';'));
                ?>
              </div><?php
        }break;
        case Dynprops::typeRadioYesNo:
        {
            $value = (isset($d['value'])? $d['value'] : 0);
            ?><div class="b-param">
                <p class="param-name"><?= $d['title']; ?></p>
                <?= '<label><input type="radio" name="'.$name.'" '.$extra.' class="'.$extraClass.'" value="2" '.($value == 2?'checked="checked"':'').' />'._t('','Есть').'</label>
                     <label><input type="radio" name="'.$name.'" '.$extra.' class="'.$extraClass.'" value="1" '.($value == 1?'checked="checked"':'').' />'._t('','Нет').'</label>
                     <label><input type="radio" name="'.$name.'" '.$extra.' class="'.$extraClass.'" value="0" '.($value == 0?'checked="checked"':'').' />'._t('','Неважно').'</label>' ?>
              </div> <?php
        }break;
        case Dynprops::typeCheckboxGroup:
        {
            $value = ( !empty($d['value']) ? $d['value'] : array() );
            ?><div class="b-param">
                <p class="param-name"><?= $d['title']; ?></p>
                <?php
                    echo $this->formCols($d['multi'], $value, create_function('$k,$dm,$value', '
                        return \'<li><label><input type="checkbox" name="'.$name.'[\'.$k.\']" '.$extra.' class="'.$extraClass.'" title="\'.$dm[\'name\'].\'" \'.(in_array($dm[\'value\'], $value)?\' checked="checked"\':\'\').\' value="\'.$dm[\'value\'].\'" /> \'.$dm[\'name\'].\'</label></li>\';'));
                ?>
              </div><?php
        }break;
        case Dynprops::typeCheckbox:
        {
            $value = (isset($d['value'])? $d['value'] : 0);
            ?><div class="b-param">
                <p class="param-name"><?= $d['title']; ?></p>
                    <?= '<input type="checkbox" name="'.$name.'" '.$extra.' class="'.$extraClass.'" title="'.$checkboxTitle.'" value="1" '.($value?'checked="checked"':'').' />' ?>
              </div> <?php
        }break;
        case Dynprops::typeSelect:
        {
            $value = (isset($d['value'])? $d['value'] : 0);
            if($d['parent']) {
               $extra .= ' ';
            ?><div class="b-param">
                <p class="param-name"><?= $d['title']; ?></p>
                    <div class="left">
                        <?= '<select name="'.$name.'" '.$extra.' onchange="addDynpropsParentSelect('.$d['id'].', this.value, \''.$prefix.'\', this);" class="'.$extraClass.'" style="width:185px;">' ?>
                        <?php
                            foreach($d['multi'] as $dm) {
                               echo '<option value="'.$dm['value'].'" '.($value == $dm['value'] ? 'selected="selected"' : '').'>'.$dm['name'].'</option>';
                            }
                            $extra = 'dyntype="'.$d['type'].'"';
                        ?>
                        <?= '</select>' ?>
                    </div>
                    <div class="left"><?= $d['child_title'].':'.($d['req']?'<span class="z-att">*</span>':'')?>
                        <?= '<select disabled="disabled" name="'.$name.'" '.$extra.' id="'.$prefix_id.$d['id'].'_child" class="'.$extraClass.'"></select>' ?>
                    </div>
                    <div class="clear"></div>
              </div>
              <?php } else { ?>
                <div class="b-param">
                    <p class="param-name"><?= $d['title']; ?></p>
                    <?
                        echo $this->formCols($d['multi'], ( ! empty($value) ? $value : array()), create_function('$k,$dm,$value', '
                            return \'<li><label><input type="checkbox" name="'.$name.'[\'.$k.\']" '.$extra.' class="'.$extraClass.'" title="\'.$dm[\'name\'].\'" \'.(in_array($dm[\'value\'], $value)?\' checked="checked"\':\'\').\' value="\'.$dm[\'value\'].\'" /> \'.$dm[\'name\'].\'</label></li>\';'));
                    ?>
                </div> <?php
              }
        }break;
        case Dynprops::typeNumber:
        {
            ?><div class="b-param">
                <p class="param-name"><?= $d['title']; ?><?= ( ! empty($d['description'])?', '.$d['description']:'') ?></p>
                <?php
                    $this->input->clean_array($d['value'], array(
                        'f' => TYPE_UNUM,
                        't' => TYPE_UNUM,
                    ));

                    echo '<div class="num-area">'._t('','от').' <input type="text" name="'.$name.'[f]" '.$extra.' value="'.$d['value']['f'].'" class="'.$extraClass.'" />'.
                         ' '._t('','до').' <input type="text" name="'.$name.'[t]" '.$extra.' value="'.$d['value']['t'].'" class="'.$extraClass.'" />&nbsp;'.
                         '</div>';

                    if($d['parent'] && isset($aData['children'][$d['id']])) {
                        echo $this->formChild($aData['children'][$d['id']], array('name'=>$prefix,'class'=>$extraClass));
                    }
                ?>
              </div> <?php
        }break;
        case Dynprops::typeRange:
        {
            ?><div class="b-param">
                <p class="param-name"><?= $d['title']; ?></p>
                <?php

                    $this->input->clean_array($d['value'], array(
                        'f' => TYPE_UNUM,
                        't' => TYPE_UNUM,
                    ));

                    $values = range($d['start'], $d['end'], $d['step']);

                    $sOptionsFrom = '';
                    $sOptionsTo = '';
                    foreach($values as $i) {
                       $sOptionsFrom .= '<option value="'.$i.'" '.($d['value']['f'] == $i ? 'selected="selected"' : '').'>'.$i.'</option>';
                       $sOptionsTo   .= '<option value="'.$i.'" '.($d['value']['t'] == $i ? 'selected="selected"' : '').'>'.$i.'</option>';
                    }
                     ?>
                    <?= _t('', 'от'); ?>&nbsp;&nbsp;<?= '<select name="'. $name .'[f]" '. $extra .' class="'. $extraClass .'" style="width:61px;"><option value="0">-</option>'. $sOptionsFrom .'</select>'; ?>&nbsp;&nbsp;
                    <?= _t('', 'до'); ?>&nbsp;&nbsp;<?= '<select name="'. $name .'[t]" '. $extra .' class="'. $extraClass .'" style="width:61px;"><option value="0">-</option>'. $sOptionsTo .'</select>'; ?>
                    <?php
                        if($d['parent'] && isset($aData['children'][$d['id']])) {
                            echo $this->formChild($aData['children'][$d['id']], array('name'=>$prefix,'class'=>$extraClass));
                        }
                    ?>
              </div> <?php
        }break;
    }
}