<?php

?>

<h2 class="mb15" id="j-index-realty-type-switches"><a href="<?= Realty::url('index') ?>"><?= _t('realty', 'Недвижимость'); ?>:</a>
    &nbsp;<span class="sub"><a href="#" class="ajax active j-switch" data-id="<?= Realty::TYPE_SALE ?>"><?= _t('realty', 'Продажа'); ?></a><span class="grey">/</span><a href="#" class="ajax j-switch" data-id="<?= Realty::TYPE_RENT ?>"><?= _t('realty', 'Аренда'); ?></a></span>
</h2>
<div id="j-index-realty-types">
    <? $type = Realty::TYPE_SALE; ?>
    <div class="j-type" data-id="<?= $type ?>">
        <div class="left w240">
            <div class="btn"><input type="button" onclick="location = '<?= Realty::url('add') ?>';" value="<?= _t('realty', 'Продать недвижимость'); ?>" ><i></i></div>
            <div class="clear"></div>
            <div class="mt20">
                <ul class="listpad">
                    <? if( ! empty($cats) ) { foreach($cats as $id=>$v) {
                        if( ! empty($ctypes[$id][$type])) { ?>
                            <li><a href="<?= Realty::url('search', array('cat'=>$v['keyword'], 'type'=>$types[$type]['keyword'])) ?>"><?= $v['title'] ?></a><span class="num"><?= $ctypes[$id][$type] ?></span></li>
                        <? } ?>
                    <? } } ?>
                </ul>
            </div>
            <div class="clear"></div>
        </div>
        <div class="right w240">
            <ul class="offerlist">
                <? foreach($types[$type]['items'] as $v) { ?>
                <li>
                    <a href="<?= $v['url'] ?>"><img src="<?= $v['img'] ?>" alt="<?= ( $v['imgcnt'] > 0 ? $v['title_alt'] : '' ) ?>" /><?= tpl::truncate($v['title'], 45) ?></a><br>
                    <span class="f12">
                        <?= tpl::formatPrice($v['price'], $v['price_curr']) ?><br />
                        <span class="grey"><?= _t('', 'г. [city]', array('city'=>$v['city_title'])) ?></span>
                    </span>
                </li>
                <? } ?>
            </ul>
        </div>
        <div class="clear"></div>
    </div>
    <? $type = Realty::TYPE_RENT; ?>
    <div class="j-type" style="display: none;" data-id="<?= $type ?>">
        <div class="left w240">
            <div class="btn"><input type="button" onclick="location = '<?= Realty::url('add') ?>';" value="<?= _t('realty', 'Сдать недвижимость'); ?>" ><i></i></div>
            <div class="clear"></div>
            <div class="mt20">
                <ul class="listpad">
                    <? if( ! empty($cats) ) { foreach($cats as $id=>$v) {
                        if( ! empty($ctypes[$id][$type])) { ?>
                            <li><a href="<?= Realty::url('search', array('cat'=>$v['keyword'], 'type'=>$types[$type]['keyword'])) ?>"><?= $v['title'] ?></a><span class="num"><?= $ctypes[$id][$type] ?></span></li>
                        <? } ?>
                    <? } } ?>
                </ul>
            </div>
            <div class="clear"></div>
        </div>
        <div class="right w240">
            <ul class="offerlist">
                <? foreach($types[$type]['items'] as $v) { ?>
                <li>
                    <a href="<?= $v['url'] ?>"><img src="<?= $v['img'] ?>" alt="<?= ( $v['imgcnt'] > 0 ? $v['title_alt'] : '' ) ?>" /><?= tpl::truncate($v['title'], 45) ?></a><br>
                    <span class="f12">
                        <?= tpl::formatPrice($v['price'], $v['price_curr']) ?><br />
                        <span class="grey"><?= _t('', 'г. [city]', array('city'=>$v['city_title'])) ?></span>
                    </span>
                </li>
                <? } ?>
            </ul>
        </div>
        <div class="clear"></div>
    </div>
</div>
<div class="tags mt15">
    <? foreach($links as $v) { ?>
        <a href="<?= $v['url'] ?>"><?= $v['title']; ?></a>
    <? } ?>
    <div class="clear"></div>
</div>

<script type="text/javascript">
<? js::start(); ?>
    $(function(){
        var $types = $('#j-index-realty-types').find('.j-type');
        $('#j-index-realty-type-switches').on('click', '.j-switch', function(e){ nothing(e);
            var id = intval($(this).data('id'));
            $(this).addClass('active').siblings().removeClass('active');
            $types.hide().filter('[data-id="'+id+'"]').show();
        });
    });
<? js::stop(); ?>
</script>