<?php
/**
 * @var $this Realty
 */
?>
<h3 class="mt20"><?= _t('realty', 'Поиск объявлений'); ?></h3>
<div class="param">
    <form id="realty-search" method="get" action="<?= Realty::url('search') ?>" class="relative">
        <div id="realty-search-counter" style="display: none; position: absolute; left: -115px; border: 1px solid #DADADA; background-color: #fff; padding: 5px 10px; width: 105px;">
            <span class="found-no f12"><?= _t('', 'ничего не найдено'); ?></span>
            <span class="found-yes f12"><span class="num">0</span> - <a href="#" onclick="return realtySearch.submit();"><?= _t('', 'показать'); ?></a></span>
        </div>
        <div class="b-param">
            <p class="param-name"><?= _t('', 'Город'); ?></p>
            <select name="rc" onchange="realtySearch.onCity(intval(this.value), this);"><?= Geo::cityOptions($f['rc'], array(-1, _t('', 'Все города'))) ?></select>
        </div>
        <div class="b-param">
            <p class="param-name"><?= _t('', 'Район'); ?></p>
            <select name="rd" id="realty-districts"><?= $districts ?></select>
        </div>
        <div class="b-param">
            <p class="param-name"><?= _t('realty', 'Объект'); ?></p>
            <select name="c" onchange="realtySearch.onCat(intval(this.value), false);"><?= $cats_options ?></select>
        </div>
        <div class="b-param">
            <p class="param-name"><?= _t('realty', 'Тип сделки'); ?></p>
            <ul id="realty-types">
                <li class="typeid-0"><label><input type="radio" <? if($f['t'] == 0){ ?>checked="checked"<? } ?> name="t" value="0" /> <?= _t('', 'Любой'); ?></label></li>
                <? foreach($types as $id=>$v){ ?>
                <li class="nn typeid-<?= $v['id'] ?>"><label><input type="radio" <? if($f['t'] == $v['id']){ ?>checked="checked"<? } ?> name="t" value="<?= $v['id'] ?>" /> <?= $v['t'] ?></label></li>
                <? } ?>
            </ul>
        </div>
        <div id="realty-dp"><?= $dp ?></div>
        <div class="b-param">
            <p class="param-name"><?= _t('', 'Цена'); ?>, <?= Site::currencyDefault() ?></p>
            <div class="num-area"><?= _t('', 'от'); ?> <input type="text" name="pf" value="<?= $f['pf'] ?>" pattern="[0-9]*" /> <?= _t('', 'до'); ?> <input type="text" name="pt" value="<?= $f['pt'] ?>" pattern="[0-9]*" /></div>
        </div>
        <div class="b-param">
            <ul>
                <li><label><input type="checkbox" name="ph" <? if($f['ph']){ ?>checked="checked"<? } ?> /><?= _t('', 'есть фотографии'); ?></label></li>
            </ul>
        </div>
        <div class="param-btn"><div class="btn"><input type="submit" value="<?= _t('', 'Найти'); ?>" /><i></i></div></div>
    </form>
</div>
<script type="text/javascript">
<? js::start(); ?>
var realtySearch = (function(){
    var $form, $dist, districts = {}, 
        $types, ctypes = <?= func::php2js($ctypes) ?>,
        $dp, dp = {}, cnt = false;
    
    $(function(){ 
        $form = $('#realty-search');
        $dist = $('#realty-districts', $form);
        $types = $('#realty-types > li', $form);
        $dp = $('#realty-dp', $form);
        realtySearch.onCat(<?= $f['c'] ?>, true);
        
        $form.on('click', ':checkbox, :radio', function(){
            updateCounter( $(this).position() );
        });
        $form.on('change', ':text, select', function(){
            updateCounter( $(this).position() );
        });        
    });

    function updateCounter(pos)
    {
        if (cnt === false) {
            cnt = {
                block: $('#realty-search-counter', $form),
                num: $('.num', cnt.block),
                yes: $('.found-yes', cnt.block),
                no: $('.found-no', cnt.block),
                timer: false
            };
        }
        
        bff.ajax('<?= Realty::url('search') ?>', $form.serialize()+'&cnt=1', function(data){
            if(data) {
                var num = intval(data.total);
                cnt.num.html( num );
                if( num>0 ) {
                    cnt.yes.show();
                    cnt.no.hide();
                } else {
                    cnt.yes.hide();
                    cnt.no.show();
                }
                cnt.block.css({top:pos.top-5}).fadeIn();
                if(cnt.timer) clearTimeout(cnt.timer);
                cnt.timer = setTimeout(function(){ cnt.block.fadeOut(); }, 5000);
            }
        });
    }
    
    return {
        onCat: function(id, init)
        {
            var block = $types.parent().parent();
            block.hide(); 
            $types.filter('.nn').hide();  
            var n = 0;
            for(var type in ctypes[id]) {
                n++;
                $types.filter('.typeid-'+type).show();
            }
            if(n>0) block.show();
            
            if(init) return;
            
            if(dp[id]!=undefined) {
                $dp.html( dp[id] ).show();
            } else {
                bff.ajax('<?= bff::urlAjax('realty','dp-form') ?>', {cat_id: id, search: 1}, function(data){
                    if(data) {
                        $dp.html( (dp[id] = data.form) ).show();
                    }
                });
            }
        },
        onCity: function(cityID, sel)
        {                      
            if(!cityID) return $dist.html( '<option value="0"><?= _t('', 'Выберите город'); ?></option>' );
            if(districts[cityID]) {
                $dist.html( districts[cityID] );
                return;
            }
            bff.ajax('<?= bff::urlAjax('geo','districts-list') ?>', {city: cityID, opts: true}, function(data){
                if(data && data.success) {
                    $dist.html( ( districts[cityID] = data.districts ) );
                }
            });
        },
        submit: function()
        {                 
            $form.submit();
            return false;
        }          
    };
}());
<? js::stop(); ?>
</script>