<?php

/**
 * Права доступа группы:
 *  - services: Сервисы
 *      - tv-channels: ТВ программа: каналы
 *      - tv-types: ТВ программа: типы программ
 */

class Services extends ServicesBase
{
    function tv_channels()
    {
        if( ! $this->haveAccessTo('tv-channels'))
            return $this->showAccessDenied();

        if(Request::isAJAX())
        {
            switch ($this->input->get('act'))
            {
                case 'edit':
                {
                    $nChannelID = $this->input->get('id', TYPE_UINT);
                    if( ! $nChannelID) $this->ajaxResponse(Errors::UNKNOWNRECORD);

                    $aData = $this->db->one_array('SELECT * FROM '.TABLE_TV_CHANNELS.' WHERE id = '.$nChannelID);
                    if (empty($aData)) $this->ajaxResponse(Errors::IMPOSSIBLE);

                    $aData['form'] = $this->viewTPL($aData, 'admin.tv.channels.form.tpl');

                    $this->ajaxResponse( $aData ); 
                } break;
                case 'toggle':
                {

                    $nChannelID = $this->input->postget('rec', TYPE_UINT);
                    if( ! $nChannelID) $this->ajaxResponse(Errors::UNKNOWNRECORD);

                    $this->db->exec('UPDATE '.TABLE_TV_CHANNELS.' SET enabled = (1 - enabled) WHERE id = '.$nChannelID);
                    
                    $this->ajaxResponse(Errors::SUCCESS);
                } break;
                case 'maintoggle':
                {

                    $nChannelID = $this->input->postget('rec', TYPE_UINT);
                    if( ! $nChannelID) $this->ajaxResponse(Errors::UNKNOWNRECORD);

                    $this->db->exec('UPDATE '.TABLE_TV_CHANNELS.' SET main = (1 - main) WHERE id = '.$nChannelID);
                    
                    $this->ajaxResponse(Errors::SUCCESS);
                } break;
                case 'rotate':
                {

                    $this->db->rotateTablednd(TABLE_TV_CHANNELS, '', 'id', 'num');
                    $this->ajaxResponse(Errors::SUCCESS);
                } break;
                case 'cleanup':
                {
                    if( ! FORDEV ) {
                        $this->ajaxResponse(Errors::ACCESSDENIED);
                    }

                    $sType = $this->input->post('type', TYPE_STR);
                    switch ($sType) {
                        case 'events':
                        {
                            $this->db->exec('TRUNCATE TABLE '.TABLE_TV_EVENTS);
                            $this->db->update(TABLE_TV_CHANNELS, array(
                                'lastday_num' => 0,
                                'lastday_date' => date('Y-m-d H:i:s', strtotime('-1 year')),
                            ));
                            $aEventTypesID = $this->db->select_one_column('SELECT id FROM '.TABLE_TV_EVENTS_TYPES);
                            if( ! empty($aEventTypesID) ) {
                                $sImagesPath = PATH_PUBLIC.'files/images/tv/events/';
                                foreach($aEventTypesID as $typeID) {
                                    $dirPath = $sImagesPath.$typeID;
                                    $dir = new DirectoryIterator($dirPath);
                                    foreach ($dir as $f) {
                                        if( $f->isFile() && ! $f->isDot() ) {
                                            @unlink( $dirPath.'/'.$f->getFilename() );
                                        }
                                    }
                                }
                            }
                        } break;
                    }
                    $this->ajaxResponse(Errors::SUCCESS);
                } break;
            }
        } 
        else if (Request::isPOST())
        {
            switch ($this->input->postget('act'))
            {
                case 'edit-finish':
                {
                    $nChannelID = $this->input->post('id', TYPE_UINT);
                    if( ! $nChannelID) $this->errors->unknownRecord();

                    $aDataCur = $this->db->one_array('SELECT * FROM '.TABLE_TV_CHANNELS.' WHERE id = '.$nChannelID);
                    if (empty($aDataCur)) $this->errors->unknownRecord();
                    
                    $aData = $this->tvChannelsProcessData();
                    if($this->errors->no()) {
                        $this->db->update(TABLE_TV_CHANNELS, $aData, array('id'=>$nChannelID));
                    }
                } break;
            }

            $this->adminRedirect(Errors::SUCCESS, bff::$event);
        }
        
        $aData = $this->tvChannelsProcessData();
        $aData['id'] = 0;
        $aData['channels'] = $this->db->select('SELECT * FROM '.TABLE_TV_CHANNELS.' ORDER BY num');
        
        $aData['form'] = $this->viewTPL($aData, 'admin.tv.channels.form.tpl');
        return $this->viewPHP($aData, 'admin.tv.channels.listing');
    }

    private function tvChannelsProcessData()
    {
        $aData = $this->input->postm(array(
                'title' => TYPE_NOTAGS,  // название
                'link'  => TYPE_NOTAGS,  // ссылка
                'main'  => TYPE_BOOL,    // основной
                'enabled' => TYPE_BOOL,  // включен ли канал
            ));
        if (Request::isPOST())
        {
            if($aData['title'] == '') {
                $this->errors->set( _t('services', 'Название канала указано некорректно') );
            }
        }
        return $aData;
    }

    function tv_types()
    {
        if( ! $this->haveAccessTo('tv-types'))
            return $this->showAccessDenied();

        if(Request::isAJAX())
        {
            switch ($this->input->get('act'))
            {
                case 'edit':
                {
                    $nChannelID = $this->input->get('id', TYPE_UINT);
                    if( ! $nChannelID) $this->ajaxResponse(Errors::UNKNOWNRECORD);

                    $aData = $this->db->one_array('SELECT * FROM '.TABLE_TV_EVENTS_TYPES.' WHERE id = '.$nChannelID);
                    if (empty($aData)) $this->ajaxResponse(Errors::IMPOSSIBLE);

                    $aData['form'] = $this->viewPHP($aData, 'admin.tv.types.form');

                    $this->ajaxResponse( $aData ); 
                } break;
                case 'rotate':
                {

                    $this->db->rotateTablednd(TABLE_TV_EVENTS_TYPES, '', 'id', 'num');
                    $this->ajaxResponse(Errors::SUCCESS);
                } break; 
            }
        } 
        else if (Request::isPOST())
        {
            switch ($this->input->postget('act'))
            {
                case 'edit-finish':
                {
                    $nChannelID = $this->input->post('id', TYPE_UINT);
                    if( ! $nChannelID) $this->errors->unknownRecord();

                    $aDataCur = $this->db->one_array('SELECT * FROM '.TABLE_TV_EVENTS_TYPES.' WHERE id = '.$nChannelID);
                    if (empty($aDataCur)) $this->errors->unknownRecord();
                    
                    $aData = $this->tvTypesProcessData();
                    if($this->errors->no()) {
                        $this->db->update(TABLE_TV_EVENTS_TYPES, $aData, array('id'=>$nChannelID));
                    }
                } break;
            }

            $this->adminRedirect(Errors::SUCCESS, bff::$event);
        }
        
        $aData = $this->tvTypesProcessData();
        $aData['id'] = 0;
        $aData['types'] = $this->db->select('SELECT * FROM '.TABLE_TV_EVENTS_TYPES.' ORDER BY num');

        $aData['form'] = $this->viewPHP($aData, 'admin.tv.types.form');
        return $this->viewPHP($aData, 'admin.tv.types.listing');
    }
    
    private function tvTypesProcessData()
    {
        $aData = $this->input->postm(array(
            'title' => TYPE_NOTAGS,  // название
            'color' => TYPE_NOTAGS,  // цвет фона
        ));

        if (Request::isPOST())
        {
            if($aData['title'] == '') {
                $this->errors->set( _t('services', 'Название типа программы указано некорректно') );
            }
        }
        return $aData;
    }

}