<?php

class Services extends ServicesBase
{
    # Подписка на новости
    public function news()
    {
        # инициализируем
        Publications::i();

        $aData['cats'] = $this->db->select('
            SELECT CL.title, C.keyword
            FROM '.TABLE_PUB_CATEGORIES.' C,
                 '.TABLE_PUB_CATEGORIES_LANG.' CL
            WHERE C.type_id = 0 AND C.pid = 0 AND C.enabled = 1 '.$this->db->langAnd(true, 'C', 'CL').'
            ORDER BY C.num');
        
        foreach($aData['cats'] as &$v) {
            $v['link'] = Publications::url('category', array('type'=>Publications::TYPE_NEWS, 'keyword'=>$v['keyword']));
            $v['rss'] = SITEURL_STATIC.'/rss/news/'.$v['keyword'].'.xml';
        } unset($v);
        
        array_push($aData['cats'], array(
            'title' => _t('services','Вся лента новостей'),
            'keyword' => 'all',
            'link' => Publications::url('list', Publications::TYPE_NEWS),
            'rss' => SITEURL_STATIC.'/rss/news/all.xml',
        ));

        # SEO: Подписка на новости
        $this->urlCorrection(static::url('news'));
        $this->seo()->canonicalUrl(static::url('news', array(), true));
        $this->seo()->setPageMeta('site', 'news', array(), $aData);

        bff::setActiveMenu('//services/news');
        return $this->viewPHP($aData, 'news');
    }
    
    # Карта сайта
    public function sitemap()
    {
        $aData = array();
        do {
            # кешируем на Х минут
            $cacheOn = true;


            if ($cacheOn)
            {
                $cache = Cache::singleton('services', 'file', array('lifeTime'=>600)); // кешируем на 10 минут
                $cacheKey = 'sitemap-'.LNG;
                if (($aData = $cache->get($cacheKey)) !== false) break;
            }

            # Новости
            if (bff::moduleExists('publications'))
            {
                $aData['news'] = array(_t('services','Новости'), false, array(
                    Publications::TYPE_NEWS    => array( _t('services','Лента новостей'), Publications::url('list', Publications::TYPE_NEWS), array()), // + common cats
                    Publications::TYPE_REPORTS => array( _t('services','Фоторепортажи'), Publications::url('list', Publications::TYPE_REPORTS), array()),  // + common cats
                    Publications::TYPE_ARTICLES=> array( _t('services','Статьи'), Publications::url('list', Publications::TYPE_ARTICLES), array()), // + common cats
                    Publications::TYPE_NAROD   => array( _t('services','Народные новости'), Publications::url('list', Publications::TYPE_NAROD), array()), // + narod cats
                ));
                # дополняем категории новостей
                Publications::i();
                $aPubCats = $this->db->select('
                    SELECT CL.title as t, C.keyword as k, C.type_id
                    FROM '.TABLE_PUB_CATEGORIES.' C,
                         '.TABLE_PUB_CATEGORIES_LANG.' CL
                    WHERE C.enabled = 1 AND C.pid = 0 '.$this->db->langAnd(true, 'C', 'CL').'
                    ORDER BY C.num');
                $aCatsCommon = array();
                $aCatsNarod = array();
                foreach($aPubCats as $v) {
                    if(!$v['type_id']) {
                        $aCatsCommon[] = $v;
                    } elseif($v['type_id']==Publications::TYPE_NAROD) {
                        $aCatsNarod[] = $v;
                    }
                }

                foreach($aData['news'][2] as $type=>$v) {
                    if($type == Publications::TYPE_NAROD) {
                        $aData['news'][2][$type][2][] = array(
                            _t('services','Все народные новости'),
                            $v[1]);
                        foreach($aCatsNarod as $vv) {
                            $aData['news'][2][$type][2][] = array($vv['t'], Publications::url('category', array('type'=>$type,'keyword'=>$vv['k'])));
                        }
                    } else {
                        $aData['news'][2][$type][2][] = array(
                            ($type == 'reports'  ? _t('services','Все фоторепортажи') :
                            ($type == 'articles' ? _t('services','Все статьи') :
                                                   _t('services','Все новости'))),
                                                   $v[1]);
                        foreach($aCatsCommon as $vv) {
                            $aData['news'][2][$type][2][] = array($vv['t'], Publications::url('category', array('type'=>$type,'keyword'=>$vv['k'])));
                        }
                    }
                }
            }

            # Афиша
            if( bff::moduleExists('afisha') )
            {
                $aData['afisha'] = array(_t('services','Афиша'), false, array(
                    'all'      => array(_t('services','Все события'), Afisha::url('index')),
                    'movie'    => array(_t('services','Кино'), Afisha::url('list', Afisha::TYPE_MOVIE)),
                    'theater'  => array(_t('services','Театр'), Afisha::url('list', Afisha::TYPE_THEATER)),
                    'exhibition' => array(_t('services','Выставки'), Afisha::url('list', Afisha::TYPE_EXHIBITION)),
                    'concert'  => array(_t('services','Концерты'), Afisha::url('list', Afisha::TYPE_CONCERT)),
                    'activity' => array(_t('services','Мероприятия'), Afisha::url('list', Afisha::TYPE_ACTIVITY)),
                    'sport'    => array(_t('services','Спорт'), Afisha::url('list', Afisha::TYPE_SPORT)),
                    'party'    => array(_t('services','Вечеринки'), Afisha::url('list', Afisha::TYPE_PARTY)),
                    'circus'   => array(_t('services','Цирк'), Afisha::url('list', Afisha::TYPE_CIRCUS)),
                ));
            }

            # Справочник
            if( bff::moduleExists('items') )
            {
                $aData['map'] = array(_t('services','Справочная'), false, array(
                    'map' => array(_t('services','Карта города'), Items::url('map'), array()), // + cats + subcats
                    'phones' => array(_t('services','Телефоны'), Items::url('phones'), array()),
                ));
                # дополняем категории справочника
                $aData['icats'] =  $this->db->select('
                    SELECT IC.id, IC.pid, ICL.title as t, IC.keyword as k
                    FROM '.TABLE_ITEMS_CATEGORIES.' IC,
                         '.TABLE_ITEMS_CATEGORIES_LANG.' ICL
                    WHERE IC.enabled = 1 '.$this->db->langAnd(true, 'IC', 'ICL').'
                    ORDER BY IC.num');
                $aData['map'][2]['map'][2] = $this->db->transformRowsToTree($aData['icats'], 'id', 'pid', 'sub');
                unset($aData['icats']);
            }

            # Объявления
            if( bff::moduleExists('bbs') )
            {
                $aCats = BBS::model()->categoriesList(2);
                $aData['bbs'] = array(_t('services','Объявления'), false, array()); // + cats + subcats
                $aData['bbs'][2] = $this->db->transformRowsToTree($aCats,'id','pid','sub');
            }

            # Работа
            if( bff::moduleExists('job') )
            {
                $aData['job'] = array(_t('services','Работа'), false, array()); // from sitemap
            }

            # Недвижимость
            if( bff::moduleExists('realty') ) {
                $aData['realty'] = array(_t('services','Недвижимость'), false, array()); // from sitemap
            }

            # Авто
            if( bff::moduleExists('auto') ) {
                $aData['auto'] = array(_t('services','Авто'), false, array()); // from sitemap
            }

            $aData['services'] = array(_t('services','Сервисы'), false, array());  // from sitemap
            $aData['business'] = array(_t('services','Бизнес'), false, array());  // from sitemap

            # дополняем разделы данными из модуля "Карта сайта"
            $aMenu = Sitemap::i()->getMenu();
            if( ! empty($aMenu['main'])) {
                $aMenu = $aMenu['main']['sub'];
                foreach(array('job','auto','realty','services','business') as $key)
                {
                    if( isset($aData[$key]) && isset($aMenu[$key]) ) {
                        foreach($aMenu[$key]['sub'] as $v) {
                            $aData[$key][2][] = array($v['title'], $v['link']);
                        }
                    }
                }
            }

            if($cacheOn) $cache->set($cacheKey, $aData);
        } while(false);

        # SEO: Карта сайта
        $this->urlCorrection(static::url('sitemap'));
        $this->seo()->canonicalUrl(static::url('sitemap', array(), true));
        $this->seo()->setPageMeta('site', 'sitemap', array(), $aData);

        bff::setActiveMenu('//services/sitemap');
        return $this->viewPHP($aData, 'sitemap');
    }
    
    # Опросы
    public function voting()
    {
        return Voting::i()->listing();
    }

    # Погода
    function weather()
    {
        $sAjaxAct = $this->input->postget('act');
        if (!empty($sAjaxAct))
        {
            switch ($sAjaxAct) {
                case 'header': {
                    $this->ajaxResponse($this->weatherNow(true));
                } break;
            }
            $this->ajaxResponse('');
        }

        $nCityID = Geo::cityID(true);
        $sDate = date('Y-m-d');

        $b10days = $this->input->get('d10', TYPE_BOOL);
        $bPrint  = $this->input->get('print', TYPE_BOOL);

        if ($b10days)
        {
            $aDays = $this->model->weatherData(array(
                'city_id' => $nCityID,
                array('city_date >= :date', ':date'=>$sDate),
                'extended' => 0,
            ), 'city_date ASC', 10);

            if(!empty($aDays)) {
                foreach($aDays as $k=>$v) {
                    $aDays[$k]['params'] = unserialize($v['params']);
                }
            } else {
                $aDays = array();
            }
        } else {
            $aDays = $this->model->weatherData(array(
                'city_id' => $nCityID,
                array('city_date >= :date', ':date'=>$sDate),
                'extended' => 1,
            ), 'city_date ASC', 3);
            if(!empty($aDays)) {
                foreach($aDays as $k=>$v) {
                    $aDays[$k]['params'] = unserialize($v['params']);
                }
            } else {
                $aDays = array();
            }
        }
        
        $aData = array(
            'today' => $this->weatherNow(),
            'days'  => &$aDays,
            '10'    => $b10days,
            'print' => $bPrint,
        );
        
        if ($bPrint) {
            View::setLayout('print');
            return $this->viewPHP($aData, 'weather');
        }

        # SEO: Погода
        $this->urlCorrection(static::url('weather'));
        $this->seo()->canonicalUrl(static::url('weather', array(), true));
        $this->seo()->setPageMeta('items', 'weather', array(
            'region' => Geo::filter('title'),
        ), $aData);

        bff::setActiveMenu('//map/weather');
        return $this->viewPHP($aData, 'weather');
    }
    
    public function weatherNow($bHeaderBlock = false)
    {
        static $cache;
        if(isset($cache)) {
            if($bHeaderBlock) {
                return $this->viewPHP($cache, 'weather.header');
            }
            return $cache;
        }

        $cityID = Geo::cityID(true);

        // ночь(6), утро(12), день(18), вечер(24)
        $aData = array(
            0 => array(),
            1 => array(),
            2 => array(),
            3 => array(),
        );
        $nHour = date('G'); // текущий час
        $sqlToday = date('Y-m-d');
        $sqlTomorrow = date('Y-m-d', strtotime('+1 day'));

        $aToday = $this->model->weatherData(array(
            'city_date' => $sqlToday,
            'city_id'   => $cityID,
            'extended'  => 1,
        ));
        if(!empty($aToday)) {
            $aToday['params'] = func::unserialize($aToday['params']);
        }
        $dayTime = array(
            6  => _t('services','Ночью'),   # ночь
            12 => _t('services','Утром'),   # утро
            18 => _t('services','Днем'),    # день
            24 => _t('services','Вечером'), # вечер
        );
        if ($nHour < 6) { # ночь
            $dayTimeOrder = array(6,12,18,24); $dayTime[6] = '';
        } else {
            $aTomorrow = $this->model->weatherData(array(
                'city_date' => $sqlTomorrow,
                'city_id'   => $cityID,
                'extended'  => 1,
            ));

            $aTomorrow['params'] = func::unserialize($aTomorrow['params']);

            if ($nHour >= 6 && $nHour < 12) { # утро
                $dayTimeOrder = array(12,18,24,6); $dayTime[12] = '';
            } else if($nHour >= 12 && $nHour < 18) { # день
                $dayTimeOrder = array(18,24,6,12); $dayTime[18] = '';
            } else { # вечер
                $dayTimeOrder = array(24,6,12,18); $dayTime[24] = '';
            }
        }

        $i = 0;
        foreach ($dayTimeOrder as $k) {
            if (isset($aToday['params'][$k])) $aData[$i] = $aToday['params'][$k];
            if ( ! empty($dayTime[$k])) $aData[$i]['time'] = $dayTime[$k];
            $i++;
        }

        $cache = $aData;
        
        if($bHeaderBlock) {
            return $this->viewPHP($cache, 'weather.header');
        }
        
        return $cache;
    }
    
    # ТВ программа
    public function tv_route()
    {
        $res = bff::route(array(
            'tv/([\d]+)\.html(.*)'  => 'services/tv_view/id=\\1', # /tv/1.html   - просмотр передачи
            //'tv/programs(.*)'      => 'services/tv_programs',     # /tv/programs - список компаний
            'tv(.*)'                => 'services/tv',             # /tv          - список ТВ программы
        ), true);

        if($res['event'] === false || !method_exists($this, $res['event']))
            $res['event'] = 'tv';

        return $this->$res['event']();
    }
    
    public function tv()
    {
        $bAll = $this->input->get('a', TYPE_BOOL);
        $nDate = $this->tvPrepareDate( $this->input->getpost('date', TYPE_NOTAGS), $bToday, true ); // => "YYYY-MM-DD"
        $sDate = date('Y-m-d', $nDate);
        $sDateFilter = $sDate;

        $timeNow = ( $bToday ? intval( date('Hi') ) : 500 ); //часыминуты

        // получаем список программ, разбиваем по каналам
        $aEvents = $this->db->select('SELECT E.id, E.channel_id as cid, E.type_id as tp, E.types, E.title as t, E.time_from as tf, E.time_to as tt, 1 as a
                    FROM '.TABLE_TV_EVENTS.' E, '.TABLE_TV_CHANNELS.' C
                    WHERE E.event_date = :date
                      AND E.channel_id = C.id AND C.enabled = 1 '.(!$bAll ? 'AND C.main = 1' : '').'
                    ORDER BY C.num, E.channel_id, E.playing', array(':date'=>$sDateFilter));
        $aChannels = $this->db->select('SELECT id, type, logo, title, link FROM '.TABLE_TV_CHANNELS.' WHERE enabled = 1 ORDER BY num');
        $aChannelsTmp = array();
        foreach($aChannels as $v) {
            $v['events'] = array();
            $v['n'] = 1;
            $aChannelsTmp[$v['id']] = $v;
        } $aChannels = $aChannelsTmp; unset($aChannelsTmp);
        
        $lastActive = false; $curChannelID = 0; $ch = array('events'=>0);
        $aTypes = array();
        foreach($aEvents as $v) 
        {
            if($v['cid']!=$curChannelID) {
                $lastActive = false;
                $curChannelID = intval($v['cid']);
                $ch = &$aChannels[$curChannelID];
            }
            
            if($bToday) 
            {
                $timeFrom = intval( str_replace(':','',$v['tf']) );
                $timeTo = intval( str_replace(':','',$v['tt']) );
                $v['a'] = ( $lastActive || ($timeFrom>=$timeNow) || (($timeNow > $timeFrom && $timeFrom > 600) && ($timeTo < 600)) ); // все что ранее 6 утра = помечаем как доступное
                if($v['a'] && !$lastActive) {
                    if(($timeFrom>$timeNow) && $ch['n'] > 1 && $timeFrom!=$timeNow) {
                        $ch['events'][$ch['n']-1]['a'] = 2;
                    } else {
                        $v['a'] = true;
                    }
                }
                $lastActive = $v['a'];
            }

            if($v['types']){
                foreach(explode(',', $v['types']) as $vv){
                    if( ! in_array($vv, $aTypes)){
                        $aTypes[] = $vv;
                    }
                }
            }
            
            $ch['events'][$ch['n']] = $v;
            $ch['n']++;
        } 

        foreach($aChannels as $chK=>$v) 
        {
            if (empty($v['events'])) unset($aChannels[$chK]);
            else if($bToday) {
                // если дата == "сегодня", отсекаем прошедние передачи
                /*
                foreach($v['events'] as $eK=>$e) {
                    if($e['a']) {
                        if($eK > 1) $aChannels[$chK]['events'] = array_slice($v['events'], $eK-1);
                        break;
                    }
                }
                */
            }
        }
        
        unset($aEvents);

        $aData['channels'] = &$aChannels;

        # SEO: ТВ программа
        $this->urlCorrection(static::url('tv'));
        $this->seo()->canonicalUrl(static::url('tv', array(), true), array('date'=>$sDate));
        $this->seo()->setPageMeta('items', 'tv', array(
            'region' => Geo::filter('title'),
            'date' => tpl::date_format2($nDate, false, false, ' ', ', ', true),
            'date2' => tpl::date_format2($nDate, false, false),
            'date3' => tpl::dateFormat($nDate),
        ), $aData);

        bff::setActiveMenu('//map/tv');
        $aData['today'] = $bToday;
        $aData['date'] = ( ! $bToday ? '?date='.$sDate.($bAll?'&a=1':'') : '' );
        $aData['days'] = $this->tvDaysFromToday($nDate, static::url('tv').'?'.($bAll?'a=1&':'').'date=');
        bff::setRightblock( $this->tvRightblock($sDate, !$bAll, array_keys($aChannels), $aTypes));
        $aData['date'] = $sDate;
        $aData['types'] = $this->db->select_key('SELECT id,color FROM '.TABLE_TV_EVENTS_TYPES.' WHERE color != ""');
        return $this->viewPHP($aData, 'tv');
    }
    
    public function tv_view()
    {
        $nEventID = $this->input->get('id', TYPE_UINT);
        $aData = $this->db->one_array('SELECT E.*, 
                            C.title as ch_title, C.logo as ch_logo, C.link as ch_link
                        FROM '.TABLE_TV_EVENTS.' E, '.TABLE_TV_CHANNELS.' C
                        WHERE E.id = '.$nEventID.' 
                          AND E.channel_id = C.id AND C.enabled = 1');
        if (empty($aData)) {
            $this->errors->error404();
        }

        # SEO: ТВ программа: просмотр
        $this->urlCorrection(static::url('tv.view', array('id'=>$nEventID)));
        $this->seo()->canonicalUrl(static::url('tv', array('id'=>$nEventID), true));
        $this->seo()->setPageMeta('items', 'tv-view', array(
            'title' => $aData['title'],
            'date' => tpl::date_format2(strtotime($aData['playing']), true, false),
            'channel' => $aData['ch_title'],
            'region' => Geo::filter('title'),
        ), $aData);

        bff::setActiveMenu('//map/tv', true);
        return $this->viewPHP($aData, 'tv.view');
    }

    public function cron()
    {
        require_once(PATH_BASE.'cron'.DS.'tv'.DS.'xmltv.php');

        exit;
    }
    
    protected function tvRightblock($sDate, $bMain, $aChannelsID, $aTypes = array())
    {
        $aData['date'] = $sDate;  
        $aData['main'] = $bMain;
        $aData['channels'] = $this->db->select('SELECT * FROM '.TABLE_TV_CHANNELS.' 
                    WHERE enabled = 1 '.
                        ($bMain ? ' AND main = 1' : '').
                        (!empty($aChannelsID) ? ' AND id IN ('.join(',', $aChannelsID).')' : ' AND id = 0').' 
                    ORDER BY num');
        $aData['types'] = $this->db->select('SELECT * FROM '.TABLE_TV_EVENTS_TYPES.( ! empty($aTypes) ? ' WHERE '.$this->db->prepareIN('id', $aTypes) : '').' ORDER BY num');
        return $this->viewPHP($aData, 'tv.rightblock');
    }

    protected function tvPrepareDate($sDate, &$bToday, $bNowIfEmpty = true)
    {
        $mResult = $bToday = false;
        
        do {
            if($sDate=='' || strlen($sDate)<10 || ! preg_match('/[\d]{4}-[\d]{2}-[\d]{2}/', $sDate)) {
                break;
            }
            $nDate = strtotime( $sDate );
            if($nDate === -1 || $nDate === false || $nDate < 342133200) //не удалось определить дату, либо дата ранее 1980 года :)
                break;

            $mResult = $nDate;
        } while(false);

        if($mResult === false)
        {
            if($bNowIfEmpty) {
                $mResult = mktime(0,0,0); // текущая дата без времени, Y-m-d 00:00:00
                $bToday = true;
            }
        } else {
            if( mktime(0,0,0) == strtotime( date('Y-m-d', $nDate) ) ) {
                $bToday = true;
            }
        }
        
        return $mResult;
    }
    
    protected function tvDaysFromToday($nDate, $sDateLink, $sLinkPostfix = '')
    {
        $aData = array(
            'date'      => $nDate, 
            'date_link' => $sDateLink,
            'date_link_postfix' => $sLinkPostfix,
        );
        return $this->viewPHP($aData, 'tv.days.fromtoday');
    }
}