<?php
/**
 * @var $this Services
 */
tpl::includeJS('tablednd', true);
?>
<?= tplAdmin::blockStart('ТВ программа / Типы программ / Редактирование типа', false, array('id'=>'tvTypeFormBlock', 'style'=>'display:none;')); ?>
<form action="" method="post" name="tvTypeFormNew">
    <input type="hidden" name="act" value="add-finish" />
    <table class="admtbl tbledit">
        <tbody class="form_params"><?= $form ?></tbody>
        <tr>
            <td colspan="2" class="row1">
                <input type="submit" class="btn btn-success button submit" value="Сохранить" />
                <input type="reset" class="btn button cancel" value="Отмена" onclick="tvTypes.toggle('cancel');" />
            </td>
        </tr>
    </table>
</form>
<?= tplAdmin::blockStop(); ?>

<?= tplAdmin::blockStart('ТВ программа / Типы программ'); ?>
<table class="table table-condensed table-hover admtbl tblhover" id="tv-types-table">
<thead>
    <tr class="header nodrag nodrop">
        <? if(FORDEV) { ?><th width="50">ID</th><? } ?>
        <th class="left">Название</th>
        <th width="60">Действие</th>
    </tr>
</thead>
<? foreach($types as $k=>$v) { $id = $v['id']; ?>
<tr class="row<?= $k%2 ?>" id="dnd-<?= $id ?>">
    <? if(FORDEV) { ?><td><?= $id ?></td><? } ?>
    <td class="left"><?= $v['title'] ?></td>
    <td>
        <a class="but edit type-edit" title="Редактировать" href="#" rel="<?= $id ?>"></a>
    </td>
</tr>
<? } if (empty($types)) { ?>
<tr class="norecords">
    <td colspan="<?= (FORDEV ? 3 : 2) ?>">нет типов программ</td>
</tr>
<? } ?>
</table>
<div>
    <div class="left"></div>
    <div class="right desc" style="width:60px; text-align:right;">
        <div class="progress" id="progress-tv-types" style="display:none;"></div>
        &darr; &uarr;
    </div>
    <br />
</div>
<?= tplAdmin::blockStop(); ?>

<script type="text/javascript">
var tvTypes = (function(){
    var $progress, $block, $blockCaption, form, formClean, $list, fChecker;
    var ajax_url = '<?= $this->adminLink('tv_types&act=') ?>';
    
    $(function(){
        form = document.forms.tvTypeFormNew;
        
        fChecker = new bff.formChecker(form);
        formClean = $(form).html();
        
        $progress = $('#progress-tv-types');
        $block = $('#tvTypeFormBlock');
        $blockCaption = $block.find('span.caption'); 
        $list = $('#tv-types-table');
        
        $list.on('click', 'a.type-edit', function(){
            var id = intval($(this).attr('rel'));
            if(id>0) edit(id);
            return false;
        });
        
        bff.rotateTable('#tv-types-table', ajax_url+'rotate', $progress);
    });

    function toggle(type, editData)
    {                                           
        switch(type) {
            case 'cancel': {
                $block.hide();
            } break;
            case 'edit': {                           
                $blockCaption.html(editData.caption);
                $(form).find('.form_params').html(editData.form);
                $block.show();
                $.scrollTo( $blockCaption, { duration:500, offset:-300 } );
                form.elements['act'].value = 'edit-finish';
            } break;
        }
        fChecker.check(true, true);
        return false;
    }

    function edit(id)
    {                          
        bff.ajax(ajax_url+'edit&id='+id,{},function(data){
            if(data) {
                toggle('edit', $.extend({caption: 'ТВ программа / Типы программ / Редактирование типа'}, data) );
            }                  
        }, $progress);
        return false;
    }
    
    return {toggle: toggle};
}());
</script>