<?php             

/**
 * Права доступа группы:
 *  - site: Настройки сайта
 *      - instructions: Инструкции
 */

class Site extends SiteBase
{
    #---------------------------------------------------------------------------------------
    # Настройки сайта
    
    function siteconfig()
    {
        if ( ! $this->haveAccessTo('settings'))
            return $this->showAccessDenied();

        $geoUrlKey = 'geo_url';
        $geoUrlDefault = Geo::URL_NONE;
        $geoUrlSettings = array(
            Geo::URL_NONE      => array('t' => 'Без региона', 'ex' => SITEURL),
            Geo::URL_SUBDOMAIN => array('t' => 'Регион в поддомене', 'ex' => Request::scheme() . '://<b>city</b>.' . SITEHOST),
        );

        $geoCoveringKey = 'geo_covering';
        $geoCoveringDefault = Geo::COVERING_CITIES;
        $geoCoveringLevels = array(
            Geo::lvlCountry => 'Выберите страну...',
            Geo::lvlCity    => 'Выберите город...'
        );
        $geoCoveringSettings = array(
            Geo::COVERING_CITIES => array('t' => 'Города (несколько)'),
        );

        if (Request::isAJAX()) {
            $aResponse = array();
            switch ($this->input->getpost('act', TYPE_STR)) {
                case 'geo-covering-options':
                {
                    $parentID = $this->input->post('id', TYPE_UINT);
                    if (!$parentID) {
                        $this->errors->reloadPage();
                        break;
                    }
                    $aList = Geo::model()->regionsList(Geo::lvlCity, array('country'=>$parentID));
                    $aResponse['options'] = HTML::selectOptions($aList, 0, $geoCoveringLevels[Geo::lvlCity], 'id', 'title');
                    $aResponse['items'] = array();
                    foreach ($aList as &$v) {
                        $aResponse['items'][$v['id']] = $v['title'];
                    }
                    unset($v);
                }
                break;
            }
            $this->ajaxResponseForm($aResponse);
        }

        $sCurrentTab = $this->input->postget('tab');
        if (empty($sCurrentTab))
            $sCurrentTab = 'general';

        $aLang = array(
            'title'          => TYPE_STR,
            'title_admin'    => TYPE_STR,
            'offline_reason' => TYPE_STR,
            'copyright'      => TYPE_STR,
        );

        if (Request::isPOST() && $this->input->post('saveconfig',TYPE_BOOL))
        {

            $conf = $this->input->postm(array(
                'enabled'       => TYPE_UINT,
                'share_code'    => TYPE_STR,
                'regions'       => TYPE_ARRAY_BOOL,
            ));
            $rebuildLinks = false;

            {
                # geo-url:
                $conf[$geoUrlKey] = $this->input->post($geoUrlKey, TYPE_NOTAGS);
                if (!array_key_exists($conf[$geoUrlKey], $geoUrlSettings)) {
                    $conf[$geoUrlKey] = $geoUrlDefault;
                }
                # тип ссылки изменился
                if (Geo::urlType() != $conf[$geoUrlKey]) {
                    $rebuildLinks = true;
                }

                # geo-covering:
                $conf[$geoCoveringKey] = $this->input->post($geoCoveringKey, TYPE_NOTAGS);
                $conf['geo_covering_lvl'] = $this->input->post('geo_covering_lvl', TYPE_ARRAY_ARRAY);
                if (!array_key_exists($conf[$geoCoveringKey], $geoCoveringSettings)) {
                    $conf[$geoCoveringKey] = $geoCoveringDefault;
                }
                foreach ($geoCoveringLevels as $k => $v) {
                    $conf['geo_covering_lvl' . $k] = 0;
                }
                foreach ($conf['geo_covering_lvl'][$conf[$geoCoveringKey]] as $k => $v) {
                    $conf['geo_covering_lvl' . $k] = $v;
                }
                unset($conf['geo_covering_lvl']);
                if ($conf[$geoCoveringKey] == Geo::COVERING_CITIES) {
                    $conf['geo_covering_lvl' . Geo::lvlCity] = join(',', $conf['geo_covering_lvl' . Geo::lvlCity]);
                }
                Geo::i()->resetCache();

                # modules regions filter:
                foreach ($conf['regions'] as $k=>$v) {
                        $conf[$k] = $v;
                } $conf['rf_all'] = array_sum($conf['regions']); unset($conf['regions']);
                if (config::get('rf_all', 0) != $conf['rf_all']) {
                    $rebuildLinks = true;
                }

                # водяной знак
                $this->watermarkSave('images_watermark',
                    $this->input->post('images_watermark_delete', TYPE_BOOL),
                    $this->input->post('images_watermark_pos_x', TYPE_NOTAGS),
                    $this->input->post('images_watermark_pos_y', TYPE_NOTAGS)
                );

            }

            $this->input->postm_lang($aLang, $conf);
            $this->db->langFieldsModify($conf, $aLang, $conf);
            config::save($conf);

            if ($rebuildLinks) {
                bff::i()->callModules('onLinksRebuild');
            }

            config::update( $this->adminLink('siteconfig&tab='.$sCurrentTab.'&errno='.Errors::SUCCESS) );
        }

        $aConfig = config::$data;
        $aConfig = array_map('stripslashes', $aConfig);
        $this->db->langFieldsSelect($aConfig, $aLang);

        $aData = $aConfig;
        $aData['tabs'] = array(
            'general' => array('t'=>'Общие настройки','a'=>0),
            'offline' => array('t'=>'Выключение сайта','a'=>0),
            'geo'     => array('t'=>'Регионы','a'=>0),
            'images'  => array('t' => 'Изображения','a'=>0),
        );

        $aData['modules'] = array(
            'publications' => array(),
            'afisha'   => array(),
            'items'    => array(),
            'job'      => array(),
            'bbs'      => array(),
            'realty'   => array(),
            'auto'     => array(),
            'business' => array(),
        );
        foreach ($aData['modules'] as $k=>&$v) {
            if (bff::i()->moduleExists($k,false)) {
                $v['t'] = $k::i()->module_title;
            } else {
                unset($aData['modules'][$k]);
            }
        } unset($v);

        $aData['images_watermark'] = $this->watermarkSettings();
        $aData['images_watermark']['exists'] = (!empty($aData['images_watermark']['file']['path']) &&
            file_exists($aData['images_watermark']['file']['path']));

       # geo-url:
        if (empty($aData[$geoUrlKey]) || !array_key_exists($aData[$geoUrlKey], $geoUrlSettings)) {
            $aData[$geoUrlKey] = $geoUrlDefault;
        }
        $aData['geo_url_settings'] = $geoUrlSettings;

        # geo-covering:
        if (empty($aData[$geoCoveringKey]) || !array_key_exists($aData[$geoCoveringKey], $geoCoveringSettings)) {
            $aData[$geoCoveringKey] = $geoCoveringDefault;
        }
        $aData['geo_covering_settings'] = $geoCoveringSettings;
        $aData['geo_covering_lvl'] = array();
        $parentID = 0;
        foreach ($geoCoveringLevels as $lvl => $title) {
            $current = Geo::coveringRegion($lvl);
            $items = Geo::model()->regionsList($lvl, array('country'=>$parentID));
            $aData['geo_covering_lvl'][$lvl] = array(
                'selected' => $current,
                'items'    => $items,
                'options'  => HTML::selectOptions($items, $current, $title, 'id', 'title')
            );
            $parentID = $current;
        } unset($parentID);

        if (Geo::coveringType(Geo::COVERING_CITIES)) {
            $aCitiesSelected = Geo::coveringRegion();
            $aData['geo_covering_cities'] = Geo::model()->regionsList(Geo::lvlCity, array('id' => $aCitiesSelected), 0, 0
                , 'FIELD(R.id, ' . join(',', $aCitiesSelected) . ')' # MySQL only
            );
        }

        if ( ! isset($aData['tabs'][$sCurrentTab]) ) {
            $sCurrentTab = key($aData['tabs']);
        }
        $aData['tabs'][$sCurrentTab]['a'] = 1;
        $aData['tab'] = $sCurrentTab;
        return $this->viewPHP($aData, 'admin.siteconfig');
    }

    #---------------------------------------------------------------------------------------
    # Инструкции

    function instructions()
    {

        /**
         * Формат:
         * array(
         *   'Название закладки' => array(
         *      'уникальный ключ' => array(
         *          't' => 'Название инструкции',
         *          'field' => 'Тип поля' // доступные: 'wy' - wysiwyg, 'text' - input::text
         *      )
         *   ),
         *   'Название закладки' => array(...)
         * )
         */
        $aData = array();
        if ( bff::moduleExists('bbs') ) {
            $aData[BBS::i()->module_title] = array(
                'bbs_add'  => array('t'=>'Добавление', 'field'=>'wy'),
                'bbs_edit' => array('t'=>'Редактирование', 'field'=>'wy'),
            );
        }
        if ( bff::moduleExists('auto') ) {
            $aData[Auto::i()->module_title] = array(
                'auto_add'  => array('t'=>'Добавление', 'field'=>'wy'),
                'auto_edit' => array('t'=>'Редактирование', 'field'=>'wy'),
            );
        }
        if ( bff::moduleExists('realty') ) {
            $aData[Realty::i()->module_title] = array(
                'realty_add'  => array('t'=>'Добавление', 'field'=>'wy'),
                'realty_edit' => array('t'=>'Редактирование', 'field'=>'wy'),
            );
        }
        if ( bff::moduleExists('job') ) {
            $aData[Job::i()->module_title] = array(
                'job_vacancy_add'  => array('t'=>'Добавление вакансии', 'field'=>'wy'),
                'job_vacancy_edit' => array('t'=>'Редактирование вакансии', 'field'=>'wy'),
                'job_resume_add'  => array('t'=>'Добавление резюме', 'field'=>'wy'),
                'job_resume_edit' => array('t'=>'Редактирование резюме', 'field'=>'wy'),
            );
        }
        return $this->instructionsForm($aData);
    }

    #---------------------------------------------------------------------------------------
    # AJAX
    
    function ajax()
    {
        if ( ! $this->security->haveAccessToAdminPanel())
            $this->ajaxResponse(Errors::ACCESSDENIED);       
        
        switch ($this->input->get('act', TYPE_STR))
        {
            case 'crop-image-init':
            {                   
                $p = $this->input->postm(array(
                    'folder'   => TYPE_STR,
                    'filename' => TYPE_STR,
                    'sizes'    => TYPE_ARRAY_ARRAY,
                    'ratio'    => TYPE_UNUM,
                    'module'   => TYPE_STR,
                ));

                if (empty($p['sizes']) || empty($p['filename']))
                    $this->ajaxResponse(Errors::IMPOSSIBLE);
                
                if ($p['module'] == 'publications')
                {         
                    # для модуля Publications, формат формирования путей к изображениям 
                    # может изменяться в зависимости от типа публикации
                    $oPublications = Publications::i();
                    $pp = $this->input->postm(array(
                        'type'       => TYPE_UINT,
                        'item_id'    => TYPE_UINT,
                        'publicated' => TYPE_STR,
                    ));
                    if (!$pp['type']) $this->ajaxResponse(Errors::IMPOSSIBLE);
                    
                    $oTypeSettings = $oPublications->getTypeSettings($pp['type']);

                    $aItemData = array('id'=>$pp['item_id'], 'size'=>$oTypeSettings->imgp['size_orig'], 
                                       'filename'=>$p['filename'], 'publicated'=>$pp['publicated']);
                    
                    $p['url'] = $oPublications->getImagesPath(true, $aItemData, $oTypeSettings);
                    $path     = $oPublications->getImagesPath(false, $aItemData, $oTypeSettings);
                } else {
                    if ( empty($p['folder']) ) {
                        $this->ajaxResponse(Errors::IMPOSSIBLE);
                    }
                    $p['url']  = bff::url($p['folder'], 'images').$p['filename'];
                    $path = bff::path($p['folder'], 'images').$p['filename'];
                }
                
                if ( ! file_exists($path)) $this->ajaxResponse(Errors::IMPOSSIBLE);

                $dim = getimagesize($path);
                $p['width'] = $dim[0];
                $p['height'] = $dim[1];

                $aResponse = $p;
                $aResponse['html'] = $this->viewPHP($p, 'admin.crop.image');
                $aResponse['res'] = $this->errors->no();                
                $this->ajaxResponse($aResponse);
            } break;
            case 'generate-keyword':
            {
                $sTitle = $this->input->post('title', TYPE_STR);
                $this->ajaxResponse(array('res'=>true, 'keyword' => mb_strtolower( func::translit( $sTitle ) ) ));
            } break;
        }            

        $this->ajaxResponse(Errors::IMPOSSIBLE);
    }

}