<?php
    /** @var $this Users */
?>
<script type="text/javascript">
    $(function(){
        bff.datepicker('#users-listing-reg-from', {yearRange: '-3:+3'});
        bff.datepicker('#users-listing-reg-to', {yearRange: '-3:+3'});
        bff.datepicker('#users-listing-auth-from', {yearRange: '-3:+3'});
        bff.datepicker('#users-listing-auth-to', {yearRange: '-3:+3'});

        var form = $('#usersFilter').get(0);
        $(form.city_name).autocomplete('index.php?s=site&ev=ajax&act=city', { valueInput: form.city, minChars: 3, width: 150,
            doPrepareText: function(html) {
                html = html.substr(0, html.toLowerCase().indexOf('<br'));
                html = html.replace(/<\/?[^>]+>/gi, ''); // striptags
                return html;
            } });
    });
</script>

<div class="tabsBar" id="j-members-tabs">
    <? foreach($statuses as $k => $v): ?>
    <span class="tab <?= $f['status'] == $k ? 'tab-active' : '' ?>"><a href="<?= $this->adminLink(bff::$event).'&status='.$k ?>"><?= $v ?></a></span>
    <? endforeach; ?>
    <div class="clear"></div>
</div>


<form action="" method="get" name="filters" id="usersFilter">
    <input type="hidden" name="s" value="users" />
    <input type="hidden" name="ev" value="listing" />
    <input type="hidden" name="order" value="<?= $order_by?>-<?= $order_dir ?>" />
    <input type="hidden" name="page" value="1" />
    <input type="hidden" name="status" value="<?= $f['status'] ?>" />
    <div class="actionBar">
        <div class="left" style="margin-right: 8px;">
            регистрация:&nbsp;
            <input type="text" name="r_from" value="<?= $f['r_from'] ?>" placeholder="от" style="width: 70px;" id="users-listing-reg-from" />&nbsp;<input type="text" name="r_to" value="<?= $f['r_to'] ?>" placeholder="до" style="width: 70px;" id="users-listing-reg-to" />
            &nbsp;&nbsp;авторизация:&nbsp;
            <input type="text" name="a_from" value="<?= $f['a_from'] ?>" placeholder="от" style="width: 70px;" id="users-listing-auth-from" />&nbsp;<input type="text" name="a_to" value="<?= $f['a_to'] ?>" placeholder="до" style="width: 70px;" id="users-listing-auth-to" />
        </div>
        <? if($this->regionsFilterEnabled() && !  Geo::cityIsOne()): ?>
        <div class="left" style="margin-right: 8px;">
            <select name="city"><?= Geo::cityOptions($f['city'], 'Все города') ?></select>
        </div>
        <? endif; ?>
        <div class="left" style="margin-right: 8px;">
            поиск:&nbsp;<input type="text" placeholder="ID / Логин / E-mail" name="q" value="<?= $f['q'] ?>" style="width:200px;" />
            <input type="submit" value="найти" class="btn btn-small button submit" />
        </div>
        <div class="right">
            <div style="display: none;" id="progress-users" class="progress"></div>
        </div>
        <div class="clear"></div>
    </div>
</form>

<table class="table table-condensed table-hover admtbl tblhover">
    <thead>
    <tr class="header">
        <th width="60">
            <? if($order_by=='user_id'): ?>
                <a href="index.php?s=users&ev=listing<?= $filter ?>&order=user_id-<?= $order_dir_needed ?>&page=1">ID
                    <div class="order-<?= $order_dir ?>"></div></a>
            <? else: ?>
                <a href="index.php?s=users&ev=listing<?= $filter ?>&order=user_id-desc&page=1">ID</a>
            <? endif; ?>
        </th>
        <th width="165" class="left">
            <? if($order_by=='email'): ?>
            <a href="index.php?s=users&ev=listing<?= $filter ?>&order=email-<?= $order_dir_needed ?>&page=1">E-mail
                <div class="order-<?= $order_dir ?>"></div></a>
            <? else: ?>
            <a href="index.php?s=users&ev=listing<?= $filter ?>&order=email-asc&page=1">E-mail</a>
            <? endif; ?>
        </th>
        <th class="left">Имя</th>
        <th width="125">
            <? if($order_by=='last_login'): ?>
            <a href="index.php?s=users&ev=listing<?= $filter ?>&order=last_login-<?= $order_dir_needed ?>&page=1">Был
                <div class="order-<?= $order_dir ?>"></div></a>
            <? else: ?>
            <a href="index.php?s=users&ev=listing<?= $filter ?>&order=last_login-desc&page=1">Был</a>
            <? endif; ?>
        </th>
        <th width="85">Действие</th>
    </tr>
    </thead>
    <? if( ! empty($users)): foreach($users as $k => $v): ?>
        <tr class="row<?= $k%2 ?><?= ! $v['activated'] ? ' disabled' : '' ?>">
            <td class="small"><?= $v['user_id'] ?></td>
            <td class="left"><a href="#" onclick="return bff.userinfo(<?= $v['user_id'] ?>);"><?= $v['email'] ?></a></td>
            <td class="left"><?= $v['name'] ?> <?= $v['surname'] ?></td>
            <td><?= tpl::dateFormat($v['last_login'], '%d.%m.%Y <span class=\"desc\">%H:%M</span>') ?></td>
            <td>
                <a id="u<?= $v['user_id'] ?>" class="but <?= ! $v['blocked'] ? 'un' : '' ?>block" href="#" onclick="return bff.userinfo(<?= $v['user_id'] ?>);"></a>
                <a class="but edit" href="index.php?s=users&amp;ev=user_edit&amp;rec=<?= $v['user_id'] ?>&amp;tuid=<?= $v['tuid'] ?>&amp;members=1"></a>
                <? /* <a class="but del" title="Удалить" href="#" onclick="return bff.redirect('index.php?s=users&amp;ev=user_action&amp;type=delete&amp;rec=<?= $v['user_id'] ?>&amp;tuid=<?= $v['tuid'] ?>&amp;member=1', 'Удалить пользователя?');" ></a> */ ?>
            </td>
        </tr>
    <? endforeach; else: ?>
    <tr class="norecords">
        <td colspan="7">нет пользователей</td>
    </tr>
    <? endif; ?>
</table>
<?= $pagenation_template ?>
