<h1><?= _t('users', 'Восстановление пароля'); ?></h1>
<form action="#" id="uForgotForm" class="mt20" style="margin-left: 10px;">
<input type="hidden" name="c" value="<?= ( isset($code) ? HTML::escape($code) : '' ); ?>" />
<input type="hidden" name="social" value="<?= $social; ?>" />
<div class="error mb10" style="display: none;"></div>
<table>
    <? if($step == 1) { ?>
    <tr>
        <td width="150"><?= _t('users', 'Укажите ваш E-mail'); ?>:</td>
        <td><div class="inp inp-w3 mb10"><input type="email" tabindex="1" name="email" autocomplete="off" /><i></i></div></td>
    </tr>
    <tr>
        <td></td>
        <td>
            <div class="btn mr10 left"><input type="button" class="button" tabindex="2" onclick="uForgot(this, 1);" value="<?= _t('users', 'получить новый пароль'); ?>" /><i></i></div>
            <div class="clear"></div>
        </td>
    </tr>
    <? } elseif($step == 2) { ?>
    <tr>
        <td width="150"><?= _t('users', 'Введите новый пароль:'); ?></td>
        <td><div class="inp inp-w3 mb10"><input type="text" tabindex="1" name="password" autocomplete="off" autocapitalize="off" /><i></i></div></td>
    </tr>
    <tr>
        <td></td>
        <td>
            <div class="btn mr10 left"><input type="button" class="button" tabindex="2" onclick="uForgot(this, 2);" value="<?= _t('users', 'изменить пароль'); ?>" /><i></i></div>
            <div class="clear"></div>
        </td>
    </tr>
    <? } ?>

</table>
</form>  

<script type="text/javascript">
<? js::start(); ?>
var uForgot = (function(){
  var inited = false, process = false;
  var form, $err, btn_val;
  
  return function(btn, step){
      if(!inited) {
          form = btn.form;
          $err = $('.error', form);
          btn_val = btn.value;
      }
      
      if(process) return;

      if(step == 1) {
          var email = $.trim(form.email.value);
          if(email.length<=3 || !bff.isEmail(email)) {
              app.fieldError(form.email);
              app.showError($err, '<?= _t('users', 'E-mail адрес указан некорректно'); ?>');
              return;
          }
          app.fieldError(form.email, false);
      } else if(step == 2) {
          if($.trim(form.password.value).length <= 3) {
              app.fieldError(form.password);
              app.showError($err, '<?= _t('users', 'Пароль слишком короткий'); ?>');
              return;
          }
          app.fieldError(form.password, false);
      }
      process = true;   
      btn.value = '<?= _t('', 'Подождите...'); ?>';
      bff.ajax('/user/forgot', $(form).serialize(), function(data, errors){
          if(data) {
              bff.redirect('/user/forgot?success=' + step);
              app.showError($err, false);
          } else {
              if(errors)
                  app.showError($err, errors);
          }
          btn.value = btn_val;
          process = false;
      });      
  };
}());
<? js::stop(); ?>
</script>