<?php

/**
 * Права доступа группы:
 *  - users: Пользователи
 *      - profile: Ваш профиль
 *      - members-listing: Список пользователей
 *      - admins-listing: Список администраторов
 *      - users-edit: Управление пользователями
 */

class Users extends UsersBase
{
	function main()
	{
		$this->login();
	}
   
    function profile()
    {
        if( ! $this->haveAccessTo('profile'))
            return $this->showAccessDenied();
        
        $bChangeLogin = false;
        
        $nUserID = User::id();
        if( ! $nUserID) $this->adminRedirect(Errors::IMPOSSIBLE, 'login');

        if (Request::isPOST())
        {
            $sLogin = $this->input->post('login', TYPE_STR);
            $bChangePassword = $this->input->post('changepass', TYPE_BOOL);
            $bChangeLogin = ( $bChangeLogin && !empty($sLogin) );

            $aData = $this->model->userData($nUserID, array('password','password_salt'));
            
            $sql = array();
            if($bChangePassword)
            {
                $this->input->postm(array(
                    'password0' => TYPE_NOTRIM, # текущий пароль
                    'password1' => TYPE_NOTRIM, # новый пароль
                    'password2' => TYPE_NOTRIM, # подтверждение нового пароля
                ), $p); extract($p);

                do{
                    if( ! $password0) {
                        $this->errors->set(_t('users','Укажите текущий пароль'), 'password0'); break;
                    }

                    if($aData['password'] != $this->security->getUserPasswordMD5($password0, $aData['password_salt'])) {
                        $this->errors->set(_t('users','Текущий пароль указан некорректно'), 'password0');
                        break;
                    }
                    
                    if (empty($password1) || strlen($password1) < $this->passwordMinLength) {
                        $this->errors->set(_t('users','Новый пароль слишком короткий'), 'password1'); break;
                    }
                    if($password1 !== $password2) {
                        $this->errors->set(_t('users','Ошибка подтверждения пароля'), 'password2'); break;
                    }
                    if( $this->errors->no() ) {
                        $sql['password'] = $this->security->getUserPasswordMD5($password1, $aData['password_salt']);
                    }
                } while(false);
            }
            
            if($this->errors->no() && $bChangeLogin) 
            {
                do{  
                    if (empty($sLogin)) {
                        $this->errors->set(_t('users','Укажите логин')); break;
                    }
                    if( ! $this->isLoginCorrect($sLogin)) {
                        $this->errors->set(_t('users','Пожалуйста для поля <strong>логин</strong> используйте символы A-Z,a-z,0-9,_'), 'login');
                        break;
                    }
                    if( $this->model->userLoginExists($sLogin, $nUserID) ) {
                        $this->errors->set(_t('users','Указанный логин уже существует, укажите другой'), 'login');
                        break;
                    }
                    
                    $sql['login'] = $sLogin;
                } while(false);
            }

            if($this->errors->no() && ! empty($sql))
            {

                $this->model->userSave($nUserID, $sql);
                $this->security->expire();
                $this->adminRedirect(Errors::SUCCESS, 'profile');
            }
        }
        
        $aUserGroups = $this->model->userGroups($nUserID);
        if (empty($aUserGroups)) $aUserGroups = array();

        $aData = User::data(array('name','login','avatar','email','sex'));
        $aData['user_id'] = $nUserID;
        $aData['tuid']    = $this->makeTUID($nUserID);
        $aData['groups']  = $aUserGroups;
        $aData['changelogin'] = $bChangeLogin;
        return $this->viewPHP($aData, 'admin.profile');
    }
                                
	function logout()
	{
        $this->security->sessionDestroy( $this->adminLink('login') );
	}

	function login()
	{
        if( $this->security->haveAccessToAdminPanel() )
            $this->adminRedirect(null, 'profile');

        $sLogin = '';
		if (Request::isPOST())
		{
            $sLogin = $this->input->post('login', TYPE_STR);
            if( ! $sLogin) $this->errors->set( _t('users','Укажите логин'), 'login' );

            $sPassword = $this->input->post('password', TYPE_NOTRIM);
            if( ! $sPassword) $this->errors->set( _t('users','Укажите пароль'), 'password' );

			if($this->errors->no())
			{
                $this->isLoginOrEmail($sLogin, $isEmail);

                $aData = $this->model->userSessionData(array(($isEmail ? 'email' : 'login') => $sLogin));

                if( ! empty($aData)) {
                    if( $aData['password'] != $this->security->getUserPasswordMD5($sPassword, $aData['password_salt']) ) {
                        $aData = false;
                    }
                }

				if( ! $aData) {
                    $this->errors->set( _t('users','Логин или пароль были указаны некорректно') );
				}
				else
				{
                    $nUserID = (integer)$aData['id'];

                    # аккаунт заблокирован
                    if($aData['blocked']==1) {
                        $this->errors->set( _t('users','Акканут заблокирован: [reason]', array('reason'=>$aData['blocked_reason'])) );
                    }
                    # проверка IP в бан-листе
                    else if( ( $mBlocked = $this->checkBan(true) ) ) {
                        $this->errors->set(  _t('users', 'Доступ заблокирован по причине:<br />[reason]', array('reason'=>$mBlocked))  );
                    }
                    # проверка доступа в админ-панель
                    else if( ! $this->security->haveAccessToAdminPanel($nUserID)) {
                        $this->errors->accessDenied();
                    }
                }
   
                if($this->errors->no())
                {
                    $aUserGroups = $this->model->userGroups($nUserID, true);

                    # стартуем сессию администратора
                    $this->security->sessionStart();

                    # обновляем статистику
                    $this->model->userSave($nUserID, false, array(
                        'last_activity' => $this->db->now(),
                        'last_login2'   => $aData['last_login'],
                        'last_login'    => $this->db->now(),
                        'last_login_ip' => Request::remoteAddress(true),
                        'session_id'    => session_id()
                    ));

					$this->security->setUserInfo($nUserID, $aUserGroups, $aData);

					$this->redirect( $this->adminLink(NULL) );
                }				
			}
		}

        $aData = array('login'=>$sLogin, 'errors'=>$this->errors->get(true));
		echo $this->viewPHP($aData, 'login', TPL_PATH);
		bff::shutdown();
	}

    //-------------------------------------------------------------------
    // users

    function listing() //members listing
    {
        if( ! $this->haveAccessTo('members-listing'))
            return $this->showAccessDenied();

        $f = $this->input->getm(array(
            'status' => TYPE_INT,
            'q'      => TYPE_STR,
            'r_from' => TYPE_STR,
            'r_to'   => TYPE_STR,
            'a_from' => TYPE_STR,
            'a_to'   => TYPE_STR,
            'page'   => TYPE_UINT,
            'city'   => TYPE_UINT,
        ));

        $sqlFilter = array('U.user_id != 1', 'U.member=1');
        $sqlBind = array();
        if($f['status']>0) {
            switch ($f['status']) {
                case 1: $sqlFilter[] = 'U.activated = 1';  break;
                case 2: $sqlFilter[] = 'U.activated = 0';  break;
                case 3: $sqlFilter[] = 'U.blocked = 1';    break;
                case 4: $sqlFilter[] = '(U.enotify & '.USERS_ENOTIFY_NEWS.')'; break;
            }
        }

        if($f['q']!='') {
            $sqlFilter[] = ' ( U.user_id = '.intval($f['q']).' 
                            OR U.login LIKE :login
                            OR U.email LIKE :email )';
            $sqlBind[':login'] = '%'.$f['q'].'%';
            $sqlBind[':email'] = '%'.$f['q'].'%';
        }
        
        # период регистрации
        if( !empty($f['r_from']) ) {
            $r_from = strtotime($f['r_from']);
            if( ! empty($r_from)) {
                $sqlFilter[] = 'U.created >= :rfrom';
                $sqlBind[':rfrom'] = date('Y-m-d', $r_from);
            }
        }
        if( !empty($f['r_to']) ) {
            $r_to = strtotime($f['r_to']);
            if( ! empty($r_to)) {
                $sqlFilter[] = 'U.created <= :rto';
                $sqlBind[':rto'] = date('Y-m-d', $r_to);
            }
        }
        if($f['city'] > 0) {
            $sqlFilter[] = 'U.city_id = :city';
            $sqlBind[':city'] = $f['city'];
        }


        # период последней авторизации
//        if( !empty($f['a_from']) ) {
//            $a_from = strtotime($f['a_from']);
//            if( ! empty($a_from)) {
//                $sqlFilter[] = 'U.created >= :afrom';
//                $sqlBind[':afrom'] = date('Y-m-d', $a_from);
//            }
//        }
//        if( !empty($f['a_to']) ) {
//            $a_to = strtotime($f['a_to']);
//            if( ! empty($a_to)) {
//                $sqlFilter[] = 'U.created <= :ato';
//                $sqlBind[':ato'] = date('Y-m-d', $a_to);
//            }
//        }

        $sqlFilter = ( !empty($sqlFilter) ? join(' AND ', $sqlFilter) : '' );

        # prepare order
        $aOrdersAllowed = array('user_id'=>'asc', 'login'=>'asc', 'email'=>'asc', 'last_login'=>'desc');
        $aData = $this->prepareOrder($orderBy, $orderDirection, 'last_login-desc', $aOrdersAllowed);

        # prepare filter URL
        if( ! $f['page']) $f['page'] = 1;
        $aData['filter'] =  '&' . http_build_query( $f );

        $nCount = (integer)$this->db->one_data( 'SELECT COUNT(U.user_id) FROM '.TABLE_USERS.' U WHERE '.$sqlFilter, $sqlBind);

        # generate pagenation
        $aData['pagenation_template'] = $this->generatePagenation($nCount, 20, $this->adminLink("listing{$aData['filter']}&order=$orderBy-$orderDirection&{pageId}"), $sqlLimit);

        # get members
        $sQuery = 'SELECT U.user_id, U.admin, U.name, U.surname, U.login, U.email, U.created, U.blocked, U.activated, US.last_login
                   FROM '.TABLE_USERS.' U
                        INNER JOIN '.TABLE_USERS_STAT.' US USING (user_id)
                   WHERE '.$sqlFilter.'
                   GROUP BY U.user_id
                   ORDER BY'." $orderBy $orderDirection ".($orderBy=='activated'?', created desc':'')." $sqlLimit";
        $aData['users'] = $this->db->select($sQuery, $sqlBind);

        foreach($aData['users'] as &$v) {
            $v['tuid'] = $this->makeTUID($v['user_id']);
        }

        $aData['statuses'] = array(0=>'все', 1=>'активированные', 2=>'неактивированные', 3=>'заблокированные', 4=>'подписавшиеся');
        $aData['f'] = $f;


        tpl::includeJS(array('datepicker','autocomplete'), true);
        return $this->viewPHP($aData, 'admin.member.listing');
    }
    
	function admin_listing() //admins listing
	{
        if( ! $this->haveAccessTo('admins-listing'))
            return $this->showAccessDenied();

        //prepare order 
        $aOrdersAllowed = array('user_id'=>'desc', 'login'=>'asc', 'email'=>'asc');
        $this->prepareOrder($orderBy, $orderDirection, 'login-asc', $aOrdersAllowed);
        
        //get users
        $sqlFilter = array('admin = 1');
        if( ! FORDEV) {
            //$sqlFilter[] = 'user_id!=1';
        }
        $nLimit = 15;
        $aData['offset'] = $this->input->getpost('offset', TYPE_UINT);
        $aData['users'] = $this->model->getUsers(join(' AND ', $sqlFilter),
                array('user_id', 'login', 'email', 'password', 'blocked', 'deleted', 'activated'),
                "$orderBy $orderDirection",
            $nLimit+1, $aData['offset']);

        $this->generatePagenationPrevNext(null, $aData, 'users', $nLimit);

        //get 'all admins groups'
        $aUsersGroups = $this->model->usersGroups(true, 'user_id');

		foreach($aData['users'] as &$v)
		{
            $v = HTML::escape($v);
            $v['tuid']   = $this->makeTUID($v['user_id']);
            $v['groups'] = '';

            if(isset($aUsersGroups[ $v['user_id'] ]))
                $v['groups'] = $aUsersGroups[ $v['user_id'] ];
		}

		return $this->viewTPL($aData, 'admin.admin.listing.tpl');
	}
    
	function user_add()
	{
        if( ! $this->haveAccessTo('users-edit'))
            return $this->showAccessDenied();
        
        $this->validateUserData(0, $aData);

		if (Request::isPOST())
		{
            $aGroupID = $aData['group_id'];

            do
            {
			    if($this->errors->no())
			    {
                    $aData['member']  = (in_array(self::GROUPID_MEMBER, $aGroupID)?1:0);
                    $aData['password_salt'] = $this->security->generatePasswordSalt();
                    $aData['password'] = $this->security->getUserPasswordMD5($aData['password'], $aData['password_salt']);
                    $aData['activated'] = 1;
                    
                    unset($aData['group_id']);

                    if (empty($aGroupID)) $aGroupID = array(self::GROUPID_MEMBER);

				    $nUserID = $this->model->userCreate($aData, $aGroupID);
				    if($nUserID>0) 
                    {
                        $sqlUpdate = array();
                        
                        # загружаем аватар
                        $aAvatar = $this->avatar($nUserID)->uploadFILES('avatar', false, false);
                        if($aAvatar!==false && !empty($aAvatar['filename'])) {
                            $sqlUpdate['avatar'] = $aAvatar['filename'];
                        }

                        # обновляем, является ли юзер администратором
                        $bIsAdmin = 0;  
                        if(count($aGroupID)==1 && current($aGroupID) == self::GROUPID_MEMBER)
                        {
                            $bIsAdmin = 0;
                        } else if(in_array(self::GROUPID_SUPERADMIN, $aGroupID) ||
                                  in_array(self::GROUPID_MODERATOR, $aGroupID)) {
                            $bIsAdmin = 1;
                        } else {
                            $aUserGroups = $this->model->groups();
                            foreach($aUserGroups as $v){
                                if($v['adminpanel'] == 1) {
                                    $bIsAdmin = 1; break;
                                }
                            }
                        }

                        if($bIsAdmin) {
                            $sqlUpdate['admin'] = $bIsAdmin;
                        }

                        if( ! empty($sqlUpdate)) {
                            $this->model->userSave($nUserID, $sqlUpdate);
                        }
                    }
                    
                    $this->adminRedirect(Errors::SUCCESS, ( ! $aData['member']?'admin_':'').'listing');
			    }
                
            } while(false);

            $aActiveGroupsID = $aGroupID;
            $aData = HTML::escape($aData, 'html', array('name','icq','skype','site'));
		}
		else
		{
			$aActiveGroupsID = array(self::GROUPID_MEMBER);
		}

        # телефоны
        $aData['phones'] = ( ! empty($aData['phones']) && is_string($aData['phones']) ? explode(';', $aData['phones'] ) : array() );

        $aData = array_merge($aData, array('password'=>'','password2'=>'','user_id'=>'','avatar'=>''));

        $this->prepareGroupsOptions($aData, array(USERS_GROUPS_SUPERADMIN), $aActiveGroupsID);

        if (empty($aData['city_id'])) {
            $aData['city_id'] = Geo::defaultCity();
        }
        $aData['city_options'] = Geo::cityOptions($aData['city_id'], ( ! $aData['city_id']?'Выбрать':false));

        $aData['user_id'] = 0;
		return $this->viewPHP($aData, 'admin.user.form');
	}
    
	function user_edit()
	{
        if( ! $this->haveAccessTo('users-edit'))
            return $this->showAccessDenied();

        if( ! ($nUserID = $this->input->get('rec', TYPE_UINT)))
            $this->adminRedirect(Errors::IMPOSSIBLE, 'listing');

		$sTUID = $this->input->get('tuid');
		if( ! $this->checkTUID($sTUID, $nUserID))
		    return $this->showAccessDenied();

        $aUserInfo = $this->model->userData($nUserID, '*', true);
        $aData = array('admin'=>0);
        
        # анализируем группы, в которые входит пользователь
        $bUserSuperadmin = 0;
        $aUserGroups = $this->model->userGroups($nUserID);
        foreach($aUserGroups as $v){
            if($v['group_id'] == self::GROUPID_SUPERADMIN) 
                $bUserSuperadmin = 1;
            if($v['adminpanel'] == 1)
                $aData['admin'] = 1;
        }
        
		if (Request::isPOST())
		{
            $this->validateUserData($nUserID, $aData);

            if( ! $aData['admin']){ //удаляем настройки предназначенные для админов
                unset($aData['im_noreply']);
            }

            $aGroupID = $aData['group_id'];
			
            if($this->errors->no())
			{


                # синхронизация с форумом
                if( $aData['login'] != $aUserInfo['login'] ) {
                    if( ! $this->forum()->onUserLoginChanged($nUserID, $aData['login'], $aUserInfo['login'], $aUserInfo['session_id'])){
                        $this->errors->set( _t('users', 'Ошибка изменения имени пользователя на форуме'));
                    }
                }
            }

            if($this->errors->no())
            {
                # основный данные
                unset($aData['group_id']);
                $aData['member'] = in_array(self::GROUPID_MEMBER,$aGroupID)?1:0;
				$this->model->userSave($nUserID, $aData);


                $sqlUpdate = array();
                
                # аватар
                $aAvatar = $this->avatar($nUserID)->uploadFILES('avatar', true, false);
                if($aAvatar!==false && !empty($aAvatar['filename'])) {
                    $sqlUpdate['avatar'] = $aAvatar['filename'];
                } else {
                    if($this->input->postget('avatar_del', TYPE_BOOL)) {
                        if( $this->avatar($nUserID)->delete(false) ) {
                            $sqlUpdate['avatar'] = '';
                        }
                    }
                }

                # связь с группами
                if($bUserSuperadmin && ! in_array(self::GROUPID_SUPERADMIN,$aGroupID))
                    $aGroupID = array_merge($aGroupID, array(self::GROUPID_SUPERADMIN));
				$this->model->userToGroups($nUserID, $aGroupID);
                
                # обновляем, является ли юзер администратором 
                $bIsAdmin = 0;  
                if($this->errors->no()) {
                    if($bUserSuperadmin || in_array(self::GROUPID_MODERATOR, $aGroupID)) {
                        $bIsAdmin = 1;
                    } elseif(count($aGroupID)==1 && current($aGroupID) == self::GROUPID_MEMBER) {
                        $bIsAdmin = 0;
                    } else {
                        $aUserGroups = $this->model->userGroups($nUserID);
                        foreach($aUserGroups as $v){
                            if($v['adminpanel'] == 1) {
                                $bIsAdmin = 1; break;
                            }
                        }
                    }

                    if($aData['admin'] != $bIsAdmin) {
                        $sqlUpdate['admin'] = $bIsAdmin;
                        if( ! $bIsAdmin) {
                            $sqlUpdate['im_noreply'] = 0;
                        }
                    }
                }

                if( ! empty($sqlUpdate)) {
                    $this->model->userSave($nUserID, $sqlUpdate);
                }
                
                # если пользователь редактирует собственные настройки
                if(User::isCurrent($nUserID))
                    $this->security->expire();
                
                $this->adminRedirect(Errors::SUCCESS, ( ! $this->input->get('members')?'admin_':'').'listing');
			}
            
			$aActiveGroupsID = $aGroupID;
			if(isset($aData['phones'])) {
                $aData['phones'] = explode(';', $aData['phones'] );
            }
		}
		else
		{
            $aActiveGroupsID = array();
			for ($j=0; $j<count($aUserGroups); $j++) {
				$aActiveGroupsID[] = $aUserGroups[$j]['group_id'];
			} 
		}

        $aData = HTML::escape(array_merge($aUserInfo, $aData), 'html', array('name','icq','skype','site'), true);

        $this->prepareGroupsOptions($aData, ($bUserSuperadmin ? null : USERS_GROUPS_SUPERADMIN), $aActiveGroupsID);

        $aData['city_options'] = Geo::cityOptions($aData['city_id'], ( ! $aData['city_id']?'Выбрать':false));

        $aData['superadmin'] = $bUserSuperadmin;
        $aData['tuid'] = $sTUID;
        $aData['frontendAuthUrl'] = static::urlBase().'/user/login_admin?user_id='.$aUserInfo['user_id'].'&hash='.$this->frontendAuthHash($aUserInfo['user_id'], $aUserInfo['email']);

		return $this->viewPHP($aData, 'admin.user.form');
	}
    
	function user_action()
	{
        if( ! $this->haveAccessTo('users-edit'))
            return $this->showAccessDenied();
            
        if( ! ($nUserID = $this->input->getpost('rec', TYPE_UINT)))
            $this->adminRedirect(Errors::IMPOSSIBLE);
 
        $sTUID = $this->input->getpost('tuid');
        if( ! $this->checkTUID($sTUID, $nUserID))
            return $this->showAccessDenied();

        if( $this->model->userIsSuperAdmin($nUserID) )
            $this->adminRedirect(Errors::ACCESSDENIED);

        switch ( $this->input->get('type') )
        {
            case 'delete':
            {

                // delete avatar
                $this->avatar($nUserID)->delete(false);
                // delete user
                $this->model->userDelete($nUserID);
            } break;
            case 'logout':
            {

                $aData = $this->model->userData($nUserID, array('session_id'));
                $sUserSessionID = $aData['session_id'];
                if( ! empty($sUserSessionID)) {
                    $this->security->impersonalizeSession($sUserSessionID, null, true);
                    $this->model->userSave($nUserID, false, array('session_id'=>''));
                    
                    $this->adminRedirect(Errors::SUCCESS, "user_edit&rec=$nUserID&tuid=$sTUID");
                }
                
            } break;
        }
            
        $this->adminRedirect(Errors::SUCCESS);
	}
    
    function ajax()
    {
        $nUserID = $this->input->getpost('id', TYPE_UINT);
        if( ! $nUserID) $this->ajaxResponse(Errors::UNKNOWNRECORD);

        switch ( $this->input->getpost('act', TYPE_STR) )
        {
            case 'user-info': // popup
            {
                $aData = $this->model->userData($nUserID, '*');

                $aData['phones'] = ( ! empty($aData['phones']) ? str_replace(';', ', ', $aData['phones']) : '-');
                $aData['tuid'] = $this->makeTUID($nUserID);
                $aData['sendmsg'] = ( bff::moduleExists('internalmail') && ($this->security->isAdmin() || $aData['im_noreply'] == 0));
                echo $this->viewPHP($aData, 'admin.user.info');
                bff::shutdown();
            } break;
            case 'user-block':
            {
                if( ! $this->haveAccessTo('users-edit') || User::isCurrent($nUserID))
                    $this->ajaxResponse(Errors::ACCESSDENIED); 

                $aData = $this->model->userData($nUserID, array('blocked','activated','email','name','session_id'));
                if (empty($aData)) $this->ajaxResponse(Errors::UNKNOWNRECORD);

                $sBlockedReason = $this->input->postget('blocked_reason', TYPE_STR, array('len'=>1000));
                $bBlocked = $this->input->postget('blocked', TYPE_BOOL);

                $aUpdate = array();
                if( ! $bBlocked ) {
                    $aUpdate['blocked'] = 0;
                } else {
                    $aUpdate['blocked'] = 1;
                    $aUpdate['blocked_reason'] = $sBlockedReason;
                }

                $bSaved = $this->model->userSave($nUserID, $aUpdate);
                if( $bSaved )
                {
                    if( $aUpdate['blocked'] != $aData['blocked'] )
                    {
                        # Триггер блокировки/разблокировки аккаунта
                        bff::i()->callModules('onUserBlocked', array($nUserID, $aUpdate['blocked']));

                        if( $aUpdate['blocked'] === 1 ) {
                            # аккаунт заблокирован
//                            bff::sendMailTemplate(
//                                array('name'=>$aData['name'],
//                                      'email'=>$aData['email'],
//                                      'blocked_reason'=>$sBlockedReason),
//                                'member_blocked', $aData['email']);

                            # убиваем сессию пользователя (если авторизован)
                            $this->security->impersonalizeSession($aData['session_id'], NULL, true);
                        } else {
                            # аккаунт разблокирован
//                            bff::sendMailTemplate(
//                                array('name'=>$aData['name'],
//                                      'email'=>$aData['email']),
//                                'member_unblocked', $aData['email']);
                        }
                    }
                }

                $this->ajaxResponse( array('reason'=>nl2br($sBlockedReason), 'blocked'=>$aUpdate['blocked']) );
            } break;
            case 'user-activate':
            {
                if( ! $this->haveAccessTo('users-edit'))
                    $this->ajaxResponse(Errors::ACCESSDENIED);

                $aData = $this->model->userData($nUserID, array('user_id', 'activated', 'blocked'));
                if (empty($aData)) {
                    $this->ajaxResponse(Errors::IMPOSSIBLE);
                }
                if($aData['activated'] == 1) {
                    $this->errors->set( _t('users','Данный аккаунт уже активирован') );
                    $this->ajaxResponse(null);
                }
                if($aData['blocked'] == 1) {
                    $this->errors->set( _t('users','Невозможно активировать заблокированный аккаунт') );
                    $this->ajaxResponse(null);
                }

                $bSuccess = $this->model->userSave($nUserID, array(
                    'activate_key' => '',
                    'activated' => 1
                ));

                if( ! empty($bSuccess) ) {
                    # триггер активации аккаунта
                    bff::i()->callModules('onUserActivated', array($nUserID));
                }

                $this->ajaxResponse( Errors::SUCCESS );
            } break;
        }
        
        $this->ajaxResponse(Errors::IMPOSSIBLE);
    }

    ### non-actions

    /**
     * Валидация пользователя
     * @param int $nUserID ID пользователя
     * @param array @ref $aData данные
     */
    private function validateUserData($nUserID, &$aData)
    {
        $aParams = array(
            'name'      => array(TYPE_NOTAGS, 'len'=>150),
            'surname'   => array(TYPE_NOTAGS, 'len'=>150),
            'login'     => array(TYPE_NOTAGS, 'len'=>30),
            'email'     => array(TYPE_NOTAGS, 'len'=>150),
            'city_id'   => TYPE_UINT,
            'sex'       => TYPE_UINT,
            'icq'       => array(TYPE_NOTAGS, 'len'=>20),
            'skype'     => array(TYPE_NOTAGS, 'len'=>100),
            'phones'    => TYPE_ARRAY,
            'group_id'  => TYPE_ARRAY_UINT,
            'enotify'   => TYPE_ARRAY_UINT,
        );
        
        if ($nUserID) {
            $aParams['changepass'] = TYPE_BOOL;   
            $aParams['password']   = array(TYPE_NOTRIM, 'len'=>50);
            $aParams['im_noreply'] = TYPE_BOOL;
        } else {
            $aParams['login'] = TYPE_NOTAGS; 
            $aParams['password'] = array(TYPE_NOTRIM, 'len'=>50);
            $aParams['password2'] = array(TYPE_NOTRIM, 'len'=>50);
        }

        if (static::profileBirthdate()) {
            $aParams['birthdate'] = TYPE_ARRAY_UINT;
        }
        
        $this->input->postm($aParams, $aData);

        if ( ! $nUserID) {
            $aData['admin'] = 0;
        }
        
        if (Request::isPOST())
        {
            # login
            if ( ! $nUserID ) {
                if ( ! $this->isLoginCorrect($aData['login']) ) {
                    $this->errors->set(_t('users','Укажите корректный логин'));
                }
            } else {
                if ( ! empty($aData['login']) ) {
                    if ( ! $this->isLoginCorrect($aData['login']) ) {
                        $this->errors->set(_t('users','Укажите корректный логин'));
                    }
                }
            }

            if ( ! $this->input->isEmail($aData['email'])) {
                $this->errors->set(_t('users','Email указан некорректно'));
            } elseif ($this->model->userEmailExists($aData['email'], $nUserID)) {
                $this->errors->set(_t('users','Указанный email уже существует'));
            }

            if ($nUserID) {
                if ($aData['changepass']) {
                    if (empty($aData['password']) || strlen($aData['password']) < $this->passwordMinLength) {
                        $this->errors->set(_t('users','Новый пароль слишком короткий'));
                    } else {
                        $aDataCurrent = $this->model->userData($nUserID, array('password_salt'));
                        $aData['password'] = $this->security->getUserPasswordMD5($aData['password'], $aDataCurrent['password_salt']);
                    }
                } else {
                    unset($aData['password']);
                }
                unset($aData['changepass']);
            } else {
                if (strlen($aData['password']) <= $this->passwordMinLength) $this->errors->set('Пароль слишком короткий');
                elseif ($aData['password'] != $aData['password2']) {
                    $this->errors->set( _t('users','Ошибка подтверждения пароля') );
                }
                unset($aData['password2']);
            }

            # пол
            if ( ! in_array($aData['sex'], array(self::SEX_FEMALE,self::SEX_MALE)))
                $aData['sex'] = self::SEX_MALE;

            # уведомления
            $aData['enotify'] = array_sum($aData['enotify']);

            $this->cleanUserData($aData);
        }
    }

    protected function prepareGroupsOptions(&$aData, $mExceptGroupKeyword, $aActiveGroupsID = array())
    {
        $exists_options = '';
        $active_options = '';
        $aGroups = $this->model->groups($mExceptGroupKeyword, false);
        for($i=0; $i<count($aGroups); $i++)
        {
            if(in_array($aGroups[$i]['group_id'], $aActiveGroupsID))
                $active_options .= '<option value="'.$aGroups[$i]['group_id'].'" style="color:'.$aGroups[$i]['color'].';">'.$aGroups[$i]['title'].'</option>';
            else
                $exists_options .= '<option value="'.$aGroups[$i]['group_id'].'" style="color:'.$aGroups[$i]['color'].';">'.$aGroups[$i]['title'].'</option>';
        }
        $aData['exists_options'] = $exists_options;
        $aData['active_options'] = $active_options;
    }

}