<?php

class Voting extends VotingBase
{
    /**
     * Список голосований
     */
    public function listing()
    {
        $aData['votings'] = $this->db->select('SELECT id, title_'.LNG.' AS title, status
                                FROM '.TABLE_VOTING.'
                                WHERE status IN('.self::STATUS_OPENED.','.self::STATUS_CLOSED.')
                                ORDER BY opened DESC');

        if( ! empty($aData['votings'])) {
            $aData['last'] = current($aData['votings']);
            if($aData['last']) {
                $aData['last']['html'] = $this->getVotingBlock($aData['last']['id'], $this->isUserVoted(User::id(), $aData['last']['id'], $aData['last']['status']), false, false);
            }
        }

        # SEO: Опросы
        $this->urlCorrection(static::url('list'));
        $this->seo()->canonicalUrl(static::url('list', array(), true));
        $this->seo()->setPageMeta('site', 'voting', array(), $aData);

        bff::setActiveMenu('//services/voting');
        return $this->viewPHP($aData, 'listing');
    }

    /**
     * Блок голосования в "правой колонке"
     * Выводится последнее добавленное открытое голосования
     */
    public function getRightBlockVoting()
    {
        $aData = $this->db->one_array('SELECT *, title_'.LNG.' AS title FROM '.TABLE_VOTING.'
                                WHERE status = '.self::STATUS_OPENED.'
                                ORDER BY id DESC LIMIT 1');
        if (empty($aData)) {
            # нет открытых голосований - возвращаем пустую строку
            return '';
        }

        $nVotingID = $aData['id'];
        $aData['answers'] = $this->db->select('SELECT *,title_'.LNG.' AS title FROM '.TABLE_VOTING_ANSWERS.'
                                WHERE voting_id = :id ORDER BY num', array(':id'=>$nVotingID));
        
        $aData['html'] = $this->getVotingBlock($nVotingID, $this->isUserVoted(User::id(), $nVotingID, false), $aData, true);
        
        return $this->viewPHP($aData, 'rightblock.voting');
    }

    public function ajax()
    {
        switch ($this->input->get('act', TYPE_STR))
        {
            case 'vote': # Голосование пользователя
            {
                $nUserID = User::id();
                $nVotingID   = $this->input->post('vid', TYPE_UINT);
                $nAnswerID   = $this->input->post('aid', TYPE_UINT);
                $bRightBlock = $this->input->post('rb', TYPE_BOOL);
                
                # неавторизованным нельзя голосовать
                if( ! $nVotingID || ! $nAnswerID || ! $nUserID) {
                    $this->showImpossible();
                }
                
                /**
                 * Проверяем:
                 * - корректный ли ID голосования
                 * - открыто ли голосование (STATUS_OPENED)
                 * - корректный ли ID ответа
                 * - не принимал ли пользователь участия в данном голосовании
                 */
                $aData = $this->db->one_array('SELECT V.id, A.id, U.user_id
                                    FROM '.TABLE_VOTING.' V,
                                         '.TABLE_VOTING_ANSWERS.' A
                                         LEFT JOIN '.TABLE_VOTING_VOTES.' U ON U.voting_id = A.voting_id AND U.user_id = :user
                                    WHERE V.id = :id AND V.status = '.self::STATUS_OPENED.'
                                      AND V.id = A.voting_id AND A.id = :answer
                                      AND U.user_id IS NULL
                                    GROUP BY V.id
                                ', array(':id'=>$nVotingID, ':answer'=>$nAnswerID, ':user'=>$nUserID));
                if (empty($aData)) {
                    $this->showImpossible();
                }
                
                if( ! $this->security->validateToken()) {
                    $this->ajaxResponse( _t('voting', 'Обновите страницу и повторите попытку голосования') );
                }
                
                # сохраняем голос
                $this->db->insert(TABLE_VOTING_VOTES, array(
                    'voting_id' => $nVotingID,
                    'answer_id' => $nAnswerID,
                    'user_id'   => $nUserID,
                ));

                # обновляем счетчик проголосовавших:
                # - за голосование
                $this->db->exec('UPDATE '.TABLE_VOTING.' SET users = users+1 WHERE id = :id', array(':id'=>$nVotingID));
                # - за ответ
                $this->db->exec('UPDATE '.TABLE_VOTING_ANSWERS.' SET votes = votes+1 WHERE id = :id', array(':id'=>$nAnswerID));

                # Формируем блок результатов голосования
                $this->ajaxResponse(array(
                    'res'  => true,
                    'html' => $this->getVotingBlock($nVotingID, true, false, $bRightBlock),
                ));

            } break;
            case 'list_expand': # Просмотр результата голосования на странице списка
            {
                $nVotingID = $this->input->post('vid', TYPE_UINT);
                $aResponse['html'] = $this->getVotingBlock($nVotingID, true, false, false);
                $this->ajaxResponseForm($aResponse);
            } break;
        }
    }

    public function cron()
    {
        if ( ! bff::cron() ) return;

        $this->model->cron();

    }

}